/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.tyrexmo.queryanalysis;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.ARQNotImplemented;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpConditional;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDiff;
import com.hp.hpl.jena.sparql.algebra.op.OpDisjunction;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroup;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLabel;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpMinus;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpProcedure;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpPropFunc;
import com.hp.hpl.jena.sparql.algebra.op.OpQuad;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpTopN;
import com.hp.hpl.jena.sparql.algebra.op.OpTriple;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementAssign;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class TransformAlgebra {
    private Stack<Object> lst;
    private Query query;
    private Converter conv;

    public TransformAlgebra(Query query) {
        this.query = query;
        Op op = Algebra.compile((Query)this.query);
        this.transformAlgebra(op);
    }

    public TransformAlgebra(String string) {
        this.query = QueryFactory.create((String)string);
        Op op = Algebra.compile((Query)this.query);
        this.transformAlgebra(op);
    }

    private void transformAlgebra(Op op) {
        this.conv = new Converter(this.query);
        op.visit((OpVisitor)this.conv);
        this.lst = this.conv.getQueryElems();
    }

    public boolean containsOpt() {
        return this.conv.containsOptional();
    }

    public boolean hasFilter() {
        return this.conv.containsFilter();
    }

    public boolean hasUnion() {
        return this.conv.containsUnion();
    }

    public Stack<Object> getQueryPattern() {
        return this.lst;
    }

    public List<Var> getResultVars() {
        if (this.query.isQueryResultStar()) {
            ArrayList<Var> arrayList = new ArrayList<Var>();
            arrayList.addAll(this.getAllVariables());
            return arrayList;
        }
        return this.query.getProjectVars();
    }

    public List<String> getProjectVars() {
        return this.query.getResultVars();
    }

    public Set<Var> getAllVariables() {
        return this.conv.variables();
    }

    public Collection<Var> getNonDistVars() {
        return this.difference(this.getResultVars(), this.getAllVariables());
    }

    private Collection<Var> difference(Collection<Var> collection, Collection<Var> collection2) {
        ArrayList<Var> arrayList = new ArrayList<Var>(collection2);
        arrayList.removeAll(collection);
        return arrayList;
    }

    public List<Triple> getTriples() {
        Object[] objectArray = this.lst.toArray();
        ArrayList<Triple> arrayList = new ArrayList<Triple>();
        for (int i = 0; i < this.lst.size(); ++i) {
            if (!(objectArray[i] instanceof Triple)) continue;
            arrayList.add((Triple)objectArray[i]);
        }
        return arrayList;
    }

    public static class Converter
    implements OpVisitor {
        private Query query;
        private ElementGroup currentGroup = null;
        private Stack<ElementGroup> stack = new Stack();
        private Stack<Object> elems = new Stack();
        private Set<Var> allVars = new HashSet<Var>();
        private boolean containsOptional = false;
        private boolean containsFilter = false;
        private boolean containsUnion = false;

        public Converter(Query query) {
            this.query = query;
            this.currentGroup = new ElementGroup();
        }

        public Stack<Object> getQueryElems() {
            return this.elems;
        }

        public boolean containsOptional() {
            return this.containsOptional;
        }

        public Set<Var> variables() {
            return this.allVars;
        }

        public boolean containsFilter() {
            return this.containsFilter;
        }

        public boolean containsUnion() {
            return this.containsUnion;
        }

        Element asElement(Op op) {
            ElementGroup elementGroup = this.asElementGroup(op);
            if (elementGroup.getElements().size() == 1) {
                return (Element)elementGroup.getElements().get(0);
            }
            return elementGroup;
        }

        ElementGroup asElementGroup(Op op) {
            this.startSubGroup();
            op.visit((OpVisitor)this);
            return this.endSubGroup();
        }

        public void visit(OpBGP opBGP) {
            this.currentGroup().addElement((Element)this.process(opBGP.getPattern()));
        }

        public void visit(OpTriple opTriple) {
            this.currentGroup().addElement((Element)this.process(opTriple.getTriple()));
        }

        private ElementTriplesBlock process(BasicPattern basicPattern) {
            int n = basicPattern.size();
            ElementTriplesBlock elementTriplesBlock = new ElementTriplesBlock();
            for (Triple triple : basicPattern) {
                Node node;
                Node node2;
                Node node3;
                elementTriplesBlock.addTriple(triple);
                this.elems.add(triple);
                if (--n >= 1) {
                    this.elems.add("AND");
                }
                if ((node3 = triple.getSubject()).isVariable() && node3 instanceof Var) {
                    this.allVars.add((Var)node3);
                }
                if ((node2 = triple.getObject()).isVariable() && node2 instanceof Var) {
                    this.allVars.add((Var)node2);
                }
                if (!(node = triple.getPredicate()).isVariable() || !(node instanceof Var)) continue;
                this.allVars.add((Var)node);
            }
            return elementTriplesBlock;
        }

        private ElementTriplesBlock process(Triple triple) {
            ElementTriplesBlock elementTriplesBlock = new ElementTriplesBlock();
            elementTriplesBlock.addTriple(triple);
            this.elems.push(triple);
            return elementTriplesBlock;
        }

        public void visit(OpQuadPattern opQuadPattern) {
            throw new ARQNotImplemented("OpQuadPattern");
        }

        public void visit(OpPath opPath) {
            throw new ARQNotImplemented("OpPath");
        }

        public void visit(OpJoin opJoin) {
            this.elems.add("(");
            Element element = this.asElement(opJoin.getLeft());
            this.elems.add("AND");
            ElementGroup elementGroup = this.asElementGroup(opJoin.getRight());
            this.elems.add(")");
            ElementGroup elementGroup2 = this.currentGroup();
            elementGroup2.addElement(element);
            elementGroup2.addElement((Element)elementGroup);
        }

        private static boolean emptyGroup(Element element) {
            if (!(element instanceof ElementGroup)) {
                return false;
            }
            ElementGroup elementGroup = (ElementGroup)element;
            return elementGroup.isEmpty();
        }

        public void visit(OpLeftJoin opLeftJoin) {
            this.containsOptional = true;
            Element element = this.asElement(opLeftJoin.getLeft());
            ElementGroup elementGroup = this.asElementGroup(opLeftJoin.getRight());
            ElementGroup elementGroup2 = this.currentGroup();
            if (!Converter.emptyGroup(element)) {
                elementGroup2.addElement(element);
            }
            elementGroup2.addElement((Element)new ElementOptional((Element)elementGroup));
        }

        public void visit(OpDiff opDiff) {
            throw new ARQNotImplemented("OpDiff");
        }

        public void visit(OpMinus opMinus) {
            this.elems.add("(");
            Element element = this.asElement(opMinus.getLeft());
            this.elems.add("MINUS");
            ElementGroup elementGroup = this.asElementGroup(opMinus.getRight());
            this.elems.add(")");
            ElementGroup elementGroup2 = this.currentGroup();
            elementGroup2.addElement(element);
            elementGroup2.addElement((Element)elementGroup);
        }

        public void visit(OpUnion opUnion) {
            this.containsUnion = true;
            this.elems.add("(");
            ElementGroup elementGroup = this.asElementGroup(opUnion.getLeft());
            this.elems.add("UNION");
            ElementGroup elementGroup2 = this.asElementGroup(opUnion.getRight());
            this.elems.add(")");
            if (elementGroup instanceof ElementUnion) {
                ElementUnion elementUnion = (ElementUnion)elementGroup;
                elementUnion.addElement((Element)elementGroup2);
                return;
            }
            ElementUnion elementUnion = new ElementUnion();
            elementUnion.addElement((Element)elementGroup);
            elementUnion.addElement((Element)elementGroup2);
            this.currentGroup().addElement((Element)elementUnion);
        }

        public void visit(OpConditional opConditional) {
            throw new ARQNotImplemented("OpCondition");
        }

        public void visit(OpFilter opFilter) {
            this.containsFilter = true;
            Element element = this.asElement(opFilter.getSubOp());
            if (this.currentGroup() != element) {
                this.currentGroup().addElement(element);
            }
            this.currentGroup();
            ExprList exprList = opFilter.getExprs();
            for (Expr expr : exprList) {
                ElementFilter elementFilter = new ElementFilter(expr);
                this.currentGroup().addElement((Element)elementFilter);
            }
        }

        public void visit(OpGraph opGraph) {
            this.startSubGroup();
            Element element = this.asElement(opGraph.getSubOp());
            ElementGroup elementGroup = this.endSubGroup();
            ElementNamedGraph elementNamedGraph = new ElementNamedGraph(opGraph.getNode(), element);
            this.currentGroup().addElement((Element)elementNamedGraph);
        }

        public void visit(OpService opService) {
            throw new ARQNotImplemented("OpService");
        }

        public void visit(OpDatasetNames opDatasetNames) {
            throw new ARQNotImplemented("OpDatasetNames");
        }

        public void visit(OpTable opTable) {
            if (opTable.isJoinIdentity()) {
                return;
            }
            throw new ARQNotImplemented("OpTable");
        }

        public void visit(OpExt opExt) {
            throw new ARQNotImplemented("OpExt");
        }

        public void visit(OpNull opNull) {
            throw new ARQNotImplemented("OpNull");
        }

        public void visit(OpLabel opLabel) {
        }

        public void visit(OpAssign opAssign) {
            for (Var var : opAssign.getVarExprList().getVars()) {
                ElementAssign elementAssign = new ElementAssign(var, opAssign.getVarExprList().getExpr(var));
                ElementGroup elementGroup = this.currentGroup();
                elementGroup.addElement((Element)elementAssign);
            }
        }

        public void visit(OpList opList) {
        }

        public void visit(OpOrder opOrder) {
            List list = opOrder.getConditions();
            for (SortCondition sortCondition : list) {
                this.query.addOrderBy(sortCondition);
            }
            opOrder.getSubOp().visit((OpVisitor)this);
        }

        public void visit(OpProject opProject) {
            this.query.setQueryResultStar(false);
            for (Var var : opProject.getVars()) {
                this.query.addResultVar((Node)var);
            }
            opProject.getSubOp().visit((OpVisitor)this);
        }

        public void visit(OpReduced opReduced) {
            this.query.setReduced(true);
            opReduced.getSubOp().visit((OpVisitor)this);
        }

        public void visit(OpDistinct opDistinct) {
            this.query.setDistinct(true);
            opDistinct.getSubOp().visit((OpVisitor)this);
        }

        public void visit(OpSlice opSlice) {
            if (opSlice.getStart() != Long.MIN_VALUE) {
                this.query.setOffset(opSlice.getStart());
            }
            if (opSlice.getLength() != Long.MIN_VALUE) {
                this.query.setLimit(opSlice.getLength());
            }
            opSlice.getSubOp().visit((OpVisitor)this);
        }

        public void visit(OpTopN opTopN) {
            throw new ARQNotImplemented("OpTopN");
        }

        public void visit(OpGroup opGroup) {
            throw new ARQNotImplemented("OpGroup");
        }

        public void visit(OpQuad opQuad) {
            throw new ARQNotImplemented("OpQuad");
        }

        public void visit(OpExtend opExtend) {
            throw new ARQNotImplemented("OpExtend");
        }

        private Element lastElement() {
            ElementGroup elementGroup = this.currentGroup;
            if (elementGroup == null || elementGroup.getElements().size() == 0) {
                return null;
            }
            int n = elementGroup.getElements().size();
            return (Element)elementGroup.getElements().get(n - 1);
        }

        private void startSubGroup() {
            ElementGroup elementGroup;
            this.push(this.currentGroup);
            this.currentGroup = elementGroup = new ElementGroup();
        }

        private ElementGroup endSubGroup() {
            ElementGroup elementGroup = this.pop();
            ElementGroup elementGroup2 = this.currentGroup;
            this.currentGroup = elementGroup;
            return elementGroup2;
        }

        private ElementGroup currentGroup() {
            return this.currentGroup;
        }

        private ElementGroup peek() {
            if (this.stack.size() == 0) {
                return null;
            }
            return this.stack.peek();
        }

        private ElementGroup pop() {
            return this.stack.pop();
        }

        private void push(ElementGroup elementGroup) {
            this.stack.push(elementGroup);
        }

        public void visit(OpProcedure opProcedure) {
            throw new ARQNotImplemented("OpProcedure");
        }

        public void visit(OpPropFunc opPropFunc) {
            throw new ARQNotImplemented("OpPropFunc");
        }

        public void visit(OpSequence opSequence) {
            throw new ARQNotImplemented("OpSequence");
        }

        public void visit(OpDisjunction opDisjunction) {
            throw new ARQNotImplemented("OpDisjunction");
        }
    }
}

