/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.tyrexmo.queryanalysis;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.alg.CycleDetector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class CycleAnalysis {
    DirectedGraph<String, DefaultEdge> queryGraph = new DefaultDirectedGraph(DefaultEdge.class);
    CycleDetector<String, DefaultEdge> detector;
    Set<String> tripleNodeNames = new HashSet<String>();
    Set<String> constantsAndDvars = new HashSet<String>();
    private static int newVarRank = 0;

    CycleAnalysis() {
    }

    public CycleAnalysis(List<Triple> list) {
        this();
        this.createGraph(list);
        this.detector = new CycleDetector(this.queryGraph);
    }

    private void createGraph(List<Triple> list) {
        for (Triple triple : list) {
            this.reification(triple);
        }
    }

    private void reification(Triple triple) {
        String string = this.getUniqueTripleNodeName();
        this.tripleNodeNames.add(string);
        String string2 = triple.getSubject().toString();
        String string3 = triple.getPredicate().toString();
        String string4 = triple.getObject().toString();
        if (triple.getSubject().isURI() || triple.getSubject().isBlank()) {
            this.constantsAndDvars.add(string2);
        }
        if (triple.getPredicate().isURI()) {
            this.constantsAndDvars.add(string3);
        }
        if (triple.getObject().isURI() || triple.getObject().isLiteral() || triple.getObject().isBlank()) {
            this.constantsAndDvars.add(string4);
        }
        this.queryGraph.addVertex((Object)string);
        this.queryGraph.addVertex((Object)string2);
        this.queryGraph.addVertex((Object)string3);
        this.queryGraph.addVertex((Object)string4);
        this.queryGraph.addEdge((Object)string2, (Object)string);
        this.queryGraph.addEdge((Object)string, (Object)string3);
        this.queryGraph.addEdge((Object)string, (Object)string4);
    }

    public boolean isDAGATree() {
        for (DefaultEdge defaultEdge : this.queryGraph.edgeSet()) {
            for (DefaultEdge defaultEdge2 : this.queryGraph.edgeSet()) {
                if (defaultEdge.equals(defaultEdge2) || !((String)this.queryGraph.getEdgeTarget((Object)defaultEdge)).equals(this.queryGraph.getEdgeTarget((Object)defaultEdge2))) continue;
                return false;
            }
        }
        return true;
    }

    private String getUniqueTripleNodeName() {
        return "xxx" + newVarRank++;
    }

    private boolean detectCycle(String string) {
        CycleDetector cycleDetector = new CycleDetector(this.queryGraph);
        if (!this.queryGraph.containsVertex((Object)string)) {
            System.err.println("Vertex does not exist in the graph");
            return false;
        }
        return cycleDetector.detectCyclesContainingVertex((Object)string);
    }

    public boolean isCycle(Collection<Var> collection) {
        boolean bl = false;
        if (!collection.isEmpty()) {
            for (Var var : collection) {
                if (!this.detectCycle(var.toString())) continue;
                bl = true;
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean isCyclic() {
        boolean bl = false;
        CycleDetector cycleDetector = new CycleDetector(this.queryGraph);
        bl = cycleDetector.detectCycles();
        return bl;
    }

    public Set<String> convertFromVarToString(Collection<Var> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Var var : collection) {
            hashSet.add(var.toString());
        }
        return hashSet;
    }

    public Set<String> convertFromVarToString(List<Var> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Var var : list) {
            hashSet.add(var.toString());
        }
        return hashSet;
    }

    public Set<String> convertListToString(List<String> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : list) {
            hashSet.add(string);
        }
        return hashSet;
    }

    public boolean isThereAcycleAmongNDvars(Collection<Var> collection) {
        boolean bl = false;
        CycleDetector cycleDetector = new CycleDetector(this.queryGraph);
        if (this.detectCyclesContainingNDvars(collection) && !collection.isEmpty()) {
            if (this.detectCyclesContainingConstantsAndDvars()) {
                bl = false;
            } else {
                Set set = cycleDetector.findCycles();
                HashSet hashSet = new HashSet();
                for (Object object : set) {
                    hashSet.addAll(this.queryGraph.edgesOf(object));
                }
                HashSet hashSet2 = new HashSet();
                for (DefaultEdge defaultEdge : hashSet) {
                    hashSet2.add(this.queryGraph.getEdgeSource((Object)defaultEdge));
                    hashSet2.add(this.queryGraph.getEdgeTarget((Object)defaultEdge));
                }
                bl = !this.cycleContainsAConstantOrADvar(hashSet2);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean detectCyclesContainingNDvars(Collection<Var> collection) {
        boolean bl = false;
        if (collection.isEmpty()) {
            bl = false;
        } else {
            Iterator<Var> iterator = collection.iterator();
            while (iterator.hasNext()) {
                CycleDetector cycleDetector = new CycleDetector(this.queryGraph);
                Var var = iterator.next();
                if (!cycleDetector.detectCyclesContainingVertex((Object)var.toString())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean detectCyclesContainingConstantsAndDvars() {
        boolean bl = false;
        if (this.constantsAndDvars.isEmpty()) {
            bl = false;
        } else {
            Iterator<String> iterator = this.constantsAndDvars.iterator();
            while (iterator.hasNext()) {
                CycleDetector cycleDetector = new CycleDetector(this.queryGraph);
                String string = iterator.next();
                if (!cycleDetector.detectCyclesContainingVertex((Object)string.toString())) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private boolean cycleContainsAConstantOrADvar(Set<String> set) {
        boolean bl = false;
        if (this.constantsAndDvars.isEmpty()) {
            bl = false;
        } else {
            for (String string : this.constantsAndDvars) {
                if (!set.contains(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean projectionCount(String string) {
        Query query = QueryFactory.create((String)string);
        return query.isQueryResultStar();
    }
}

