/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.tyrexmo.queryanalysis;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import fr.inrialpes.tyrexmo.queryanalysis.CycleAnalysis;
import fr.inrialpes.tyrexmo.queryanalysis.TransformAlgebra;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Analysis {
    static final Logger logger = LoggerFactory.getLogger(Analysis.class);
    protected Options options = null;
    protected String queryDir = null;
    protected String outputType = "html";
    protected String outputFile = null;
    protected PrintStream stream = null;
    static final int NONE = 0;
    static final int AND = 1;
    static final int UNION = 2;
    static final int OPT = 3;
    static final int FILTER = 4;
    static final int UNION_OPT = 5;
    static final int OPT_FILTER = 6;
    static final int FILTER_UNION = 7;
    static final int UNION_OPT_FILTER = 8;
    static final int CYCLE = 0;
    static final int DAG = 1;
    static final int TREE = 2;
    static final int PROJ = 0;
    static final int NOPROJ = 1;
    int totalNumber = 0;
    int correctNumber = 0;
    int failure = 0;
    int ndVarCycles = 0;
    int[][][] resultArray = new int[2][3][9];
    String missingPrefixes = "PREFIX dbpedia: <http://dbpedia.org/resource/>\nPREFIX dbpprop: <http://dbpedia.org/property/>\nPREFIX dbpedia-owl: <http://dbpedia.org/ontology/>\nPREFIX geo: <http://www.example.com/>\nPREFIX foaf: <http://xmlns.com/foaf/0.1/>\n\n";

    public Analysis() {
        for (int i = 0; i <= 1; ++i) {
            for (int j = 0; j <= 2; ++j) {
                for (int k = 0; k <= 8; ++k) {
                    this.resultArray[i][j][k] = 0;
                }
            }
        }
        this.options = new Options();
        this.options.addOption("h", "help", false, "Print this page");
        OptionBuilder.withLongOpt((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Result FILE");
        OptionBuilder.withArgName((String)"FILE");
        this.options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withLongOpt((String)"format");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Output format [NIY]");
        OptionBuilder.withArgName((String)"TYPE (asc|plot)");
        this.options.addOption(OptionBuilder.create((char)'f'));
    }

    public static void main(String[] stringArray) throws Exception {
        new Analysis().run(stringArray);
    }

    public void run(String[] stringArray) throws Exception, IOException {
        String[] stringArray2 = null;
        try {
            File[] fileArray = new PosixParser();
            CommandLine commandLine = fileArray.parse(this.options, stringArray);
            if (commandLine.hasOption('h')) {
                this.usage();
                System.exit(0);
            }
            if (commandLine.hasOption('f')) {
                this.outputType = commandLine.getOptionValue('f');
            }
            if (commandLine.hasOption('o')) {
                this.outputFile = commandLine.getOptionValue('o');
            }
            if ((stringArray2 = commandLine.getArgs()).length < 1) {
                logger.error("Usage: TestContain SolverClass Q1 Q2");
                this.usage();
                System.exit(-1);
            }
        }
        catch (ParseException parseException) {
            logger.error(parseException.getMessage());
            this.usage();
            System.exit(-1);
        }
        this.queryDir = stringArray2[0];
        this.stream = this.outputFile == null ? System.out : new PrintStream(new FileOutputStream(this.outputFile));
        for (File file : new File(this.queryDir).listFiles()) {
            if (!file.isFile()) continue;
            logger.trace(file.toString());
            ++this.totalNumber;
            try {
                this.analyse(file);
                ++this.correctNumber;
            }
            catch (Exception exception) {
                ++this.failure;
            }
        }
        this.render();
    }

    public String read(String string) throws IOException {
        String string2 = "";
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string2 + " " + string3;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string2;
    }

    public void analyse(File file) throws Exception {
        String string = this.read(file.toString());
        string = this.missingPrefixes + string;
        Query query = QueryFactory.create((String)string);
        TransformAlgebra transformAlgebra = new TransformAlgebra(string);
        CycleAnalysis cycleAnalysis = new CycleAnalysis(transformAlgebra.getTriples());
        int n = transformAlgebra.getNonDistVars().size() != 0 ? 0 : 1;
        int n2 = cycleAnalysis.isCyclic() ? 0 : (cycleAnalysis.isDAGATree() ? 2 : 1);
        int n3 = transformAlgebra.containsOpt() ? (transformAlgebra.hasUnion() ? (transformAlgebra.hasFilter() ? 8 : 5) : (transformAlgebra.hasFilter() ? 6 : 3)) : (transformAlgebra.hasUnion() ? (transformAlgebra.hasFilter() ? 7 : 2) : (transformAlgebra.hasFilter() ? 4 : 0));
        cycleAnalysis.constantsAndDvars.addAll(cycleAnalysis.convertFromVarToString(transformAlgebra.getResultVars()));
        if (cycleAnalysis.isThereAcycleAmongNDvars(transformAlgebra.getNonDistVars())) {
            ++this.ndVarCycles;
        }
        int[] nArray = this.resultArray[n][n2];
        int n4 = n3;
        nArray[n4] = nArray[n4] + 1;
    }

    public void renderOldStyle() {
        int n = this.resultArray[0][2][2] + this.resultArray[0][2][5] + this.resultArray[0][2][7] + this.resultArray[0][2][8] + this.resultArray[1][2][2] + this.resultArray[1][2][5] + this.resultArray[1][2][7] + this.resultArray[1][2][8];
        int n2 = n * 100 / this.correctNumber;
        int n3 = n;
        this.stream.println("Tree UCQ\t" + n + "\t" + n * 100 / this.correctNumber);
        n = this.resultArray[0][2][0] + this.resultArray[0][2][3] + this.resultArray[0][2][4] + this.resultArray[0][2][6] + this.resultArray[1][2][0] + this.resultArray[1][2][3] + this.resultArray[1][2][4] + this.resultArray[1][2][6];
        n2 += n * 100 / this.correctNumber;
        n3 += n;
        this.stream.println("Tree Others\t" + n + "\t" + n * 100 / this.correctNumber);
        n = this.resultArray[0][1][2] + this.resultArray[0][1][5] + this.resultArray[0][1][7] + this.resultArray[0][1][8] + this.resultArray[1][1][2] + this.resultArray[1][1][5] + this.resultArray[1][1][7] + this.resultArray[1][1][8];
        n2 += n * 100 / this.correctNumber;
        n3 += n;
        this.stream.println("DAG UCQ\t\t" + n + "\t" + n * 100 / this.correctNumber);
        n = this.resultArray[0][1][0] + this.resultArray[0][1][3] + this.resultArray[0][1][4] + this.resultArray[0][1][6] + this.resultArray[1][1][0] + this.resultArray[1][1][3] + this.resultArray[1][1][4] + this.resultArray[1][1][6];
        this.stream.println("DAG Others\t" + n + "\t" + n * 100 / this.correctNumber);
        n2 += n * 100 / this.correctNumber;
        n3 += n;
        n = this.resultArray[0][0][0] + this.resultArray[0][0][2] + this.resultArray[0][0][3] + this.resultArray[0][0][4] + this.resultArray[0][0][5] + this.resultArray[0][0][6] + this.resultArray[0][0][7] + this.resultArray[0][0][8] + this.resultArray[1][0][0] + this.resultArray[1][0][2] + this.resultArray[1][0][3] + this.resultArray[1][0][4] + this.resultArray[1][0][5] + this.resultArray[1][0][6] + this.resultArray[1][0][7] + this.resultArray[1][0][8];
        this.stream.println("Cyclic\t\t" + n + "\t" + n * 100 / this.correctNumber);
        this.stream.println("TOTAL\t\t" + (n3 += n) + "\t" + (n2 += n * 100 / this.correctNumber) + "\n");
        this.stream.println("\nNumber of queries with cycles using only ndvariables: " + this.ndVarCycles + "\n");
    }

    public void render() {
        this.stream.println("\n" + this.failure + " errors over " + this.totalNumber + " queries (residu: " + this.correctNumber + ")\n");
        this.renderOldStyle();
        int n = this.resultArray[0][0][0] + this.resultArray[0][0][2] + this.resultArray[0][0][3] + this.resultArray[0][0][4] + this.resultArray[0][0][5] + this.resultArray[0][0][6] + this.resultArray[0][0][7] + this.resultArray[0][0][8] + this.resultArray[0][1][0] + this.resultArray[0][1][2] + this.resultArray[0][1][3] + this.resultArray[0][1][4] + this.resultArray[0][1][5] + this.resultArray[0][1][6] + this.resultArray[0][1][7] + this.resultArray[0][1][8] + this.resultArray[0][2][0] + this.resultArray[0][2][2] + this.resultArray[0][2][3] + this.resultArray[0][2][4] + this.resultArray[0][2][5] + this.resultArray[0][2][6] + this.resultArray[0][2][7] + this.resultArray[0][2][8];
        int n2 = this.resultArray[1][0][0] + this.resultArray[1][0][2] + this.resultArray[1][0][3] + this.resultArray[1][0][4] + this.resultArray[1][0][5] + this.resultArray[1][0][6] + this.resultArray[1][0][7] + this.resultArray[1][0][8] + this.resultArray[1][1][0] + this.resultArray[1][1][2] + this.resultArray[1][1][3] + this.resultArray[1][1][4] + this.resultArray[1][1][5] + this.resultArray[1][1][6] + this.resultArray[1][1][7] + this.resultArray[1][1][8] + this.resultArray[1][2][0] + this.resultArray[1][2][2] + this.resultArray[1][2][3] + this.resultArray[1][2][4] + this.resultArray[1][2][5] + this.resultArray[1][2][6] + this.resultArray[1][2][7] + this.resultArray[1][2][8];
        this.stream.println("\t\tproj (" + n + ")\t\t\tnoproj (" + n2 + ")");
        this.stream.println("\t\ttree\tdag\tcycle\ttree\tdag\tcycle");
        boolean bl = false;
        this.printOneLine("none\t", 0, bl);
        this.printOneLine("union\t", 2, bl);
        this.printOneLine("opt\t", 3, bl);
        this.printOneLine("filter\t", 4, bl);
        this.printOneLine("un-opt\t", 5, bl);
        this.printOneLine("opt-filt", 6, bl);
        this.printOneLine("filt-un\t", 7, bl);
        this.printOneLine("un-opt-filt", 8, bl);
        bl = true;
        this.stream.println("\t\tproj (" + n * 100 / this.correctNumber + ")\t\t\tnoproj (" + n2 * 100 / this.correctNumber + ")");
        this.stream.println("\t\ttree\tdag\tcycle\ttree\tdag\tcycle");
        this.printOneLine("none\t", 0, bl);
        this.printOneLine("union\t", 2, bl);
        this.printOneLine("opt\t", 3, bl);
        this.printOneLine("filter\t", 4, bl);
        this.printOneLine("un-opt\t", 5, bl);
        this.printOneLine("opt-filt", 6, bl);
        this.printOneLine("filt-un\t", 7, bl);
        this.printOneLine("un-opt-filt", 8, bl);
    }

    public void printOneLine(String string, int n, boolean bl) {
        if (bl) {
            this.stream.println(string + "\t" + this.resultArray[0][2][n] * 100 / this.correctNumber + "\t" + this.resultArray[0][1][n] * 100 / this.correctNumber + "\t" + this.resultArray[0][0][n] * 100 / this.correctNumber + "\t" + this.resultArray[1][2][n] * 100 / this.correctNumber + "\t" + this.resultArray[1][1][n] * 100 / this.correctNumber + "\t" + this.resultArray[1][0][n] * 100 / this.correctNumber);
        } else {
            this.stream.println(string + "\t" + this.resultArray[0][2][n] + "\t" + this.resultArray[0][1][n] + "\t" + this.resultArray[0][0][n] + "\t" + this.resultArray[1][2][n] + "\t" + this.resultArray[1][1][n] + "\t" + this.resultArray[1][0][n]);
        }
    }

    public void usage() {
        Package package_ = this.getClass().getPackage();
        new HelpFormatter().printHelp(80, package_ + " [options] queryDir\nAnalyses the queries contained in queryDir", "\nOptions:", this.options, "");
    }
}

