/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.tyrexmo.qcwrapper.lmu;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.rdf.model.Model;
import fr.inrialpes.tyrexmo.qcwrapper.lmu.AxiomEncoder;
import fr.inrialpes.tyrexmo.qcwrapper.lmu.EncodeLHSQuery;
import fr.inrialpes.tyrexmo.qcwrapper.lmu.EncodeRHSQuery;
import fr.inrialpes.tyrexmo.queryanalysis.CycleAnalysis;
import fr.inrialpes.tyrexmo.queryanalysis.TransformAlgebra;
import fr.inrialpes.tyrexmo.testqc.ContainmentSolver;
import fr.inrialpes.tyrexmo.testqc.ContainmentTestException;
import fr.inrialpes.wam.treelogic.BottomUpSolver.FormulaSolver;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeSolverWrapper
implements ContainmentSolver {
    static final Logger logger = LoggerFactory.getLogger(TreeSolverWrapper.class);
    private static String theta = "<-s>spr & <p>spr & <o>spr & !<s>true & !<-p>true & !<-o>true";
    private static String eta = "!<-s>true & !<o>true & !<p>true & !<d>true & !<-d>true & !<s>spr & !<-p>spr & !<-o>spr";
    private static String kappa = "[-s](" + eta + ") & [p](" + eta + ") & [o](" + eta + ")";
    private static final String phiR = "(let x1 = nu " + theta + " & " + kappa + " & (!<d>true | <d>x1) in x1 end)";
    private FormulaSolver fs = null;
    private String WarmupFormula = "((let $v1 =  (_varx & <1>(_takesCourse & <2>_Course10))  | <1>$v1 | <2>$v1 in $v1) & (let $v0 =  (_varx & <1>(_takesCourse & <2>_Course20))  | <1>$v0 | <2>$v0 in $v0)) & ~((let $v2 =  (_varx & <1>(_takesCourse & <2>_Course10))  | <1>$v2 | <2>$v2 in $v2))";

    @Override
    public void warmup() {
        this.evaluateFormula(this.WarmupFormula);
    }

    @Override
    public boolean entailed(Query query, Query query2) throws ContainmentTestException {
        return this.entailedUnderSchema((String)null, query, query2);
    }

    @Override
    public boolean entailedUnderSchema(Model model, Query query, Query query2) throws ContainmentTestException {
        throw new ContainmentTestException("Cannot yet parse Jena Models");
    }

    @Override
    public boolean entailedUnderSchema(String string, Query query, Query query2) throws ContainmentTestException {
        String string2;
        String string3;
        TransformAlgebra transformAlgebra = new TransformAlgebra(query);
        TransformAlgebra transformAlgebra2 = new TransformAlgebra(query2);
        if (this.supportedTest(query, transformAlgebra, query2, transformAlgebra2)) {
            if (this.useSameEncoding(query, query2)) {
                string3 = new EncodeLHSQuery(transformAlgebra).getFormula();
                string2 = new EncodeLHSQuery(transformAlgebra).getFormula();
            } else {
                string3 = new EncodeLHSQuery(transformAlgebra).getFormula();
                string2 = new EncodeRHSQuery(transformAlgebra2).getFormula();
            }
        } else {
            throw new ContainmentTestException("Cannot deal with such a test");
        }
        String string4 = "(" + string3 + ") & ~(" + string2 + ")";
        if (string != null) {
            string4 = string4 + " & " + new AxiomEncoder().encodeSchema(string);
        }
        transformAlgebra = null;
        transformAlgebra2 = null;
        string3 = null;
        string2 = null;
        int n = this.evaluateFormula(string4);
        if (n == -1) {
            throw new ContainmentTestException("Solver error");
        }
        return n == 0;
    }

    protected int evaluateFormula(String string) {
        this.fs = new FormulaSolver();
        return this.fs.solve_formula_int_result(string, false, false, false, false, false, false, null);
    }

    @Override
    public void cleanup() {
        this.fs = null;
        System.gc();
    }

    private boolean supportedTest(Query query, TransformAlgebra transformAlgebra, Query query2, TransformAlgebra transformAlgebra2) {
        return !this.containsOptional(transformAlgebra, transformAlgebra2) && !this.isValidQueryType(query, query2) && !this.isCyclic(transformAlgebra, transformAlgebra2) && !this.haveSameDistVar(query, query2);
    }

    protected boolean containsOptional(TransformAlgebra transformAlgebra, TransformAlgebra transformAlgebra2) {
        return transformAlgebra.containsOpt() || transformAlgebra2.containsOpt();
    }

    protected boolean useSameEncoding(Query query, Query query2) {
        return query.equals((Object)query2);
    }

    protected boolean isValidQueryType(Query query, Query query2) {
        return query.isConstructType() || query2.isConstructType() || query.isDescribeType() || query2.isDescribeType();
    }

    protected boolean isCyclic(TransformAlgebra transformAlgebra, TransformAlgebra transformAlgebra2) {
        CycleAnalysis cycleAnalysis = new CycleAnalysis(transformAlgebra.getTriples());
        CycleAnalysis cycleAnalysis2 = new CycleAnalysis(transformAlgebra2.getTriples());
        return cycleAnalysis.isCyclic() || cycleAnalysis2.isCyclic();
    }

    protected boolean haveSameDistVar(Query query, Query query2) {
        List list = query2.getResultVars();
        Collections.sort(list);
        List list2 = query.getResultVars();
        Collections.sort(list2);
        return !((Object)list).equals(list2);
    }
}

