/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.tyrexmo.qcwrapper.lmu;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.core.Var;
import fr.inrialpes.tyrexmo.qcwrapper.lmu.QueryToFormula;
import fr.inrialpes.tyrexmo.queryanalysis.TransformAlgebra;
import java.util.Collection;
import java.util.List;
import java.util.Stack;

public class EncodeRHSQuery
extends QueryToFormula {
    private TransformAlgebra algebra;
    private Collection<Var> ndvar;
    private Stack<Object> triples;
    private List<String> distVars;

    public EncodeRHSQuery(String string) {
        this.algebra = new TransformAlgebra(string);
        this.ndvar = this.algebra.getNonDistVars();
        this.triples = this.algebra.getQueryPattern();
        this.distVars = this.algebra.getProjectVars();
    }

    public EncodeRHSQuery(Query query) {
        this.algebra = new TransformAlgebra(query);
        this.ndvar = this.algebra.getNonDistVars();
        this.triples = this.algebra.getQueryPattern();
        this.distVars = this.algebra.getProjectVars();
    }

    public EncodeRHSQuery(TransformAlgebra transformAlgebra) {
        this.algebra = transformAlgebra;
        this.ndvar = this.algebra.getNonDistVars();
        this.triples = this.algebra.getQueryPattern();
        this.distVars = this.algebra.getProjectVars();
    }

    @Override
    protected String getFormula() {
        return this.mathcalA(this.triples);
    }

    @Override
    protected String formatSubject(Triple triple) {
        String string = "";
        if (triple.getSubject().isVariable()) {
            string = this.distVars.contains(triple.getSubject().getName()) ? "_var" + triple.getSubject().getName() : "T";
        }
        if (triple.getSubject().isURI()) {
            string = "_" + triple.getSubject().getLocalName();
        }
        if (triple.getSubject().isBlank()) {
            string = triple.getSubject().getBlankNodeLabel();
            String string2 = "abcdefghijklmnopqrstuvwxyz";
            int n = (int)(Math.random() * 26.0);
            String string3 = string2.substring(n, n + 1);
            string = "_" + string3 + string;
        }
        return string;
    }

    @Override
    protected String formatPredicate(Triple triple) {
        String string = "";
        if (triple.getPredicate().isVariable()) {
            string = this.distVars.contains(triple.getPredicate().getName()) ? "_var" + triple.getPredicate().getName() : "T";
        }
        if (triple.getPredicate().isURI()) {
            string = "_" + triple.getPredicate().getLocalName();
        }
        return string;
    }

    @Override
    protected String formatObject(Triple triple) {
        String string = "";
        if (triple.getObject().isVariable()) {
            string = this.distVars.contains(triple.getObject().getName()) ? "_var" + triple.getObject().getName() : "T";
        }
        if (triple.getObject().isURI()) {
            string = "_" + triple.getObject().getLocalName();
        }
        if (triple.getObject().isLiteral()) {
            string = "_" + triple.getObject().getLiteralLexicalForm();
        }
        if (triple.getObject().isBlank()) {
            string = triple.getSubject().getBlankNodeLabel();
            String string2 = "abcdefghijklmnopqrstuvwxyz";
            int n = (int)(Math.random() * 26.0);
            String string3 = string2.substring(n, n + 1);
            string = "_" + string3 + string;
        }
        return string;
    }
}

