/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.tyrexmo.qcwrapper.lmu;

import com.hp.hpl.jena.graph.Triple;
import fr.inrialpes.tyrexmo.qcwrapper.lmu.QueryToFormula;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AxiomEncoder
extends QueryToFormula {
    private String axiom;
    private Collection<String> axioms = new ArrayList<String>();
    private final String _SUBCLASS = "sc";
    private final String _SUBPROPERTY = "sp";
    private final String _DOM = "dom";
    private final String _RANGE = "range";
    private final String _EQUIV = "equiv";
    private String phiC;

    public AxiomEncoder(String string) {
        System.err.println("AXIOMENCODER Created");
        this.setAxiom(string);
        this.createEncoding();
    }

    public AxiomEncoder(Collection<String> collection) {
        System.err.println("AXIOMENCODER Created");
        this.setAxioms(collection);
        this.createEncoding();
    }

    public AxiomEncoder() {
    }

    public String encodeSchema(String string) {
        if (string.endsWith("C1")) {
            return this.rdfs1();
        }
        if (string.endsWith("C2")) {
            return this.rdfs2();
        }
        if (string.endsWith("C3")) {
            return this.rdfs3();
        }
        if (string.endsWith("C4")) {
            return this.rdfs4();
        }
        return "true";
    }

    private String rdfs1() {
        String string = "~(let $X = (_GraduateStudent & ~_Student) | <1>$X | <-1>$X | <2>$X | <-2>$X in $X)";
        String string2 = "~(let $Y = (_UndergradStudent & ~_Student) | <1>$Y | <-1>$Y | <2>$Y | <-2>$Y in $Y)";
        return "(" + string + " & " + string2 + ")";
    }

    private String rdfs2() {
        String string = "~(let $Y = (<1>_headOf & ~<1>(_type & <2>_Professor)) | <1>$Y | <-1>$Y | <2>$Y | <-2>$Y in $Y)";
        String string2 = "~(let $Y = (_headOf & ~<2><1>(_type & <2>_Department)) | <1>$Y | <-1>$Y | <2>$Y | <-2>$Y in $Y)";
        String string3 = "~(let $Z = (_Chair & ~_Professor) | <1>$Z | <-1>$Z | <2>$Z | <-2>$Z in $Z)";
        return "(" + string + " & " + string2 + " & " + string3 + ")";
    }

    private String rdfs3() {
        String string = "~(let $X = (_maleHeadOf & ~_headOf) | <1>$X | <-1>$X | <2>$X | <-2>$X in $X)";
        String string2 = "~(let $Y = (_femaleHeadOf & ~_headOf) | <1>$Y | <-1>$Y | <2>$Y | <-2>$Y in $Y)";
        String string3 = "~(let $Z = (<1>_headOf & ~<1>(_type & <2>_FullProfessor)) | <1>$Z | <-1>$Z | <2>$Z | <-2>$Z in $Z)";
        String string4 = "~(let $R = (_FullProfessor & ~_Professor) | <1>$R | <-1>$R | <2>$R | <-2>$R in $R)";
        return "(" + string + " & " + string2 + " & " + string4 + " & " + string3 + ")";
    }

    private String rdfs4() {
        String string = "~(let $X = (_CsCourse & ~_Course) | <1>$X | <-1>$X | <2>$X | <-2>$X in $X)";
        return "(" + string + ")";
    }

    protected void setAxiom(String string) {
        this.axiom = string;
    }

    protected String getAxiom() {
        return this.axiom;
    }

    protected void setAxioms(Collection<String> collection) {
        this.axioms = collection;
    }

    protected Collection<String> getAxioms() {
        return this.axioms;
    }

    public String getEncoding(String string) {
        String string2 = "";
        String[] stringArray = string.split(" ");
        if (stringArray.length >= 3) {
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            String string5 = stringArray[2];
            if (string4.equals("sc")) {
                string2 = this.getSubclassFormula(string3, string5);
            } else if (string4.equals("sp")) {
                string2 = this.getSubpropertyFormula(string3, string5);
            } else if (string4.equals("dom")) {
                string2 = this.getDomFormula(string3, string5);
            } else if (string4.equals("range")) {
                string2 = this.getRangeFormula(string3, string5);
            } else if (string4.equals("equiv")) {
                string2 = this.getEquivFormula(string3, string5);
            }
        }
        return string2;
    }

    private String getEquivFormula(String string, String string2) {
        String string3 = this.genVarName();
        this.muVars.add(string3);
        return "(let " + string3 + " = nu (" + string + " <-> " + string2 + ")  & ([d]" + string3 + " & [s]" + string3 + " & [-s]" + string3 + " & [p]" + string3 + " & [-p]" + string3 + " & [o]" + string3 + " & [-o]" + string3 + ") in " + string3 + " end)";
    }

    private String getSubclassFormula(String string, String string2) {
        String string3 = this.genVarName();
        this.muVars.add(string3);
        return "(let " + string3 + " = nu (" + string + " -> " + string2 + ")  & ([d]" + string3 + " & [s]" + string3 + " & [-s]" + string3 + " & [p]" + string3 + " & [-p]" + string3 + " & [o]" + string3 + " & [-o]" + string3 + ") in " + string3 + " end)";
    }

    private String getSubpropertyFormula(String string, String string2) {
        String string3 = this.genVarName();
        this.muVars.add(string3);
        return "(let " + string3 + " = nu (" + string + " -> " + string2 + ")  & ([d]" + string3 + " & [-s]" + string3 + " & [p]" + string3 + " & [o]" + string3 + ") in " + string3 + " end)";
    }

    private String getDomFormula(String string, String string2) {
        String string3 = this.genVarName();
        this.muVars.add(string3);
        return "(let " + string3 + " = nu (<s>(<p>" + string + " -> <p>type & <o>" + string2 + "))  & ([d]" + string3 + " & [s]" + string3 + " & [-s]" + string3 + " & [p]" + string3 + " & [-p]" + string3 + " & [o]" + string3 + " & [-o]" + string3 + ") in " + string3 + " end)";
    }

    private String getRangeFormula(String string, String string2) {
        String string3 = this.genVarName();
        this.muVars.add(string3);
        return "(let " + string3 + " = nu (<-o><p>" + string + " -> <s>(<p>type & <o>" + string2 + "))  & ([d]" + string3 + " & [s]" + string3 + " & [-s]" + string3 + " & [p]" + string3 + " & [-p]" + string3 + " & [o]" + string3 + " & [-o]" + string3 + ") in " + string3 + " end)";
    }

    protected String conjunctEncodingOfAxioms(List<String> list) {
        String string = "";
        if (!list.isEmpty()) {
            string = string + list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                string = string + " & " + list.get(i);
            }
        }
        return string;
    }

    private void createEncoding() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.axiom == null && this.axioms == null) {
            return;
        }
        if (this.axiom != null) {
            arrayList.add(this.getEncoding(this.getAxiom()));
        } else if (this.axioms != null) {
            for (String string : this.axioms) {
                arrayList.add(this.getEncoding(string));
            }
        }
        this.setFormula(this.conjunctEncodingOfAxioms(arrayList));
    }

    private void setFormula(String string) {
        this.phiC = string;
    }

    @Override
    public String getFormula() {
        return this.phiC;
    }

    @Override
    protected String formatSubject(Triple triple) {
        return null;
    }

    @Override
    protected String formatPredicate(Triple triple) {
        return null;
    }

    @Override
    protected String formatObject(Triple triple) {
        return null;
    }
}

