/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.tyrexmo.qcwrapper.afmu;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.core.Var;
import fr.inrialpes.tyrexmo.qcwrapper.afmu.QueryToFormula;
import fr.inrialpes.tyrexmo.queryanalysis.TransformAlgebra;
import java.util.Collection;
import java.util.List;
import java.util.Stack;

public class EncodeRHSQuery
extends QueryToFormula {
    private TransformAlgebra algebra;
    private Collection<Var> ndvar;
    private Stack<Object> triples;
    private List<String> distVars;

    public EncodeRHSQuery(String string) {
        this.algebra = new TransformAlgebra(string);
        this.ndvar = this.algebra.getNonDistVars();
        this.triples = this.algebra.getQueryPattern();
        this.distVars = this.algebra.getProjectVars();
    }

    public EncodeRHSQuery(Query query) {
        this.algebra = new TransformAlgebra(query);
        this.ndvar = this.algebra.getNonDistVars();
        this.triples = this.algebra.getQueryPattern();
        this.distVars = this.algebra.getProjectVars();
    }

    @Override
    public String getFormula() {
        return this.mathcalA(this.triples);
    }

    @Override
    protected String formatSubject(Triple triple) {
        String string = "";
        if (triple.getSubject().isVariable()) {
            string = this.distVars.contains(triple.getSubject().getName()) ? "var" + triple.getSubject().getName() : "true";
        }
        if (triple.getSubject().isURI()) {
            string = triple.getSubject().getLocalName();
        }
        if (triple.getSubject().isBlank()) {
            string = triple.getSubject().getBlankNodeLabel();
            String string2 = "abcdefghijklmnopqrstuvwxyz";
            int n = (int)(Math.random() * 26.0);
            String string3 = string2.substring(n, n + 1);
            string = string3 + string;
        }
        return string;
    }

    @Override
    protected String formatPredicate(Triple triple) {
        String string = "";
        if (triple.getPredicate().isVariable()) {
            string = this.distVars.contains(triple.getPredicate().getName()) ? "var" + triple.getPredicate().getName() : "true";
        }
        if (triple.getPredicate().isURI()) {
            string = triple.getPredicate().getLocalName();
        }
        return string;
    }

    @Override
    protected String formatObject(Triple triple) {
        String string = "";
        if (triple.getObject().isVariable()) {
            string = this.distVars.contains(triple.getObject().getName()) ? "var" + triple.getObject().getName() : "true";
        }
        if (triple.getObject().isURI()) {
            string = triple.getObject().getLocalName();
        }
        if (triple.getObject().isLiteral()) {
            string = triple.getObject().getLiteralLexicalForm();
        }
        if (triple.getObject().isBlank()) {
            string = triple.getSubject().getBlankNodeLabel();
            String string2 = "abcdefghijklmnopqrstuvwxyz";
            int n = (int)(Math.random() * 26.0);
            String string3 = string2.substring(n, n + 1);
            string = string3 + string;
        }
        return string;
    }
}

