/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.tyrexmo.qcwrapper.afmu;

import com.hp.hpl.jena.graph.Triple;
import fr.inrialpes.tyrexmo.qcwrapper.afmu.QueryToFormula;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AxiomEncoder
extends QueryToFormula {
    private String axiom;
    private Collection<String> axioms = new ArrayList<String>();
    private final String _SUBCLASS = "sc";
    private final String _SUBPROPERTY = "sp";
    private final String _DOM = "dom";
    private final String _RANGE = "range";
    private final String _EQUIV = "equiv";
    private String phiC;

    public AxiomEncoder(String string) {
        System.err.println("AXIOMENCODER Created");
        this.setAxiom(string);
        this.createEncoding();
    }

    public AxiomEncoder(Collection<String> collection) {
        System.err.println("AXIOMENCODER Created");
        this.setAxioms(collection);
        this.createEncoding();
    }

    public AxiomEncoder() {
    }

    public String encodeSchema(String string) {
        if (string.endsWith("C1")) {
            return this.rdfs1();
        }
        if (string.endsWith("C2")) {
            return this.rdfs2();
        }
        if (string.endsWith("C3")) {
            return this.rdfs3();
        }
        if (string.endsWith("C4")) {
            return this.rdfs4();
        }
        if (string.endsWith("C5")) {
            return this.rdfs5();
        }
        return "true";
    }

    private String rdfs1() {
        String string = "(let xnu2 = nu (graduatestudent -> student) & ([s]xnu2 & [p]xnu2 &  [o]xnu2 & [-s]xnu2 & [-p]xnu2 &  [-o]xnu2 & [d]xnu2) in xnu2 end)";
        String string2 = "(let xnu3 = nu (undergradstudent -> student) & ([s]xnu3 & [p]xnu3 &  [o]xnu3 & [-s]xnu3 & [-p]xnu3 &  [-o]xnu3 & [d]xnu3) in xnu3 end)";
        return "(" + string + " & " + string2 + ")";
    }

    private String rdfs2() {
        String string = "(let xnu5 = nu (<-s>ss &<p>headof & <o>true -> <-s>ss & <p>type & <o>professor) & ([s]xnu5 & [p]xnu5 &  [o]xnu5 & [-s]xnu5 & [-p]xnu5 &  [-o]xnu5 & [d]xnu5) in xnu5 end)";
        String string2 = "(let xnu3 = nu (<-s>true & <p>headof & <o>o -><d>(<-s>o & <p>type & <o>department)) & ([s]xnu3 & [p]xnu3 &  [o]xnu3 & [-s]xnu3 & [-p]xnu3 &  [-o]xnu3 & [d]xnu3) in xnu3 end)";
        String string3 = "(let xnu2 = nu (chair -> professor) & ([s]xnu2 & [p]xnu2 &  [o]xnu2 & [-s]xnu2 & [-p]xnu2 &  [-o]xnu2 & [d]xnu2) in xnu2 end)";
        return "(" + string + " & " + string2 + " & " + string3 + ")";
    }

    private String rdfs3() {
        String string = "(let xnu2 = nu (maleheadof -> headof) & ([s]xnu2 & [p]xnu2 &  [o]xnu2 & [-s]xnu2 & [-p]xnu2 &  [-o]xnu2 & [d]xnu2) in xnu2 end)";
        String string2 = "(let xnu3 = nu (femaleheadof -> headof) & ([s]xnu3 & [p]xnu3 &  [o]xnu3 & [-s]xnu3 & [-p]xnu3 &  [-o]xnu3 & [d]xnu3) in xnu3 end)";
        String string3 = "(let xnu4 = nu (fullprofessor -> professor) & ([s]xnu4 & [p]xnu4 &  [o]xnu4 & [-s]xnu4 & [-p]xnu4 &  [-o]xnu4 & [d]xnu4) in xnu4 end)";
        String string4 = "(let xnu5 = nu (<-s>true & <p>headof & <o>true -> <-s>true & <p>type & <o>fullprofessor) & ([s]xnu5 & [p]xnu5 &  [o]xnu5 & [-s]xnu5 & [-p]xnu5 &  [-o]xnu5 & [d]xnu5) in xnu5 end)";
        return "(" + string + " & " + string2 + " & " + string3 + " & " + string4 + ")";
    }

    private String rdfs4() {
        String string = "(let xnu2 = nu (cscourse -> course) & ([s]xnu2 & [p]xnu2 &  [o]xnu2 & [-s]xnu2 & [-p]xnu2 &  [-o]xnu2 & [d]xnu2) in xnu2 end)";
        return "(" + string + ")";
    }

    private String rdfs5() {
        String string = "(let xnu2 = nu (ss & <s>(<p>sc & <o>(yy & <s>(<p>sc & <o>oo))  -> (ss & <s>(<p>sc & <o>oo)))) & ([s]xnu2 & [p]xnu2 &  [o]xnu2 & [-s]xnu2 & [-p]xnu2 &  [-o]xnu2 & [d]xnu2) in xnu2 end)";
        return "(" + string + ")";
    }

    protected void setAxiom(String string) {
        this.axiom = string;
    }

    protected String getAxiom() {
        return this.axiom;
    }

    protected void setAxioms(Collection<String> collection) {
        this.axioms = collection;
    }

    protected Collection<String> getAxioms() {
        return this.axioms;
    }

    public String getEncoding(String string) {
        String string2 = "";
        String[] stringArray = string.split(" ");
        if (stringArray.length >= 3) {
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            String string5 = stringArray[2];
            if (string4.equals("sc")) {
                string2 = this.getSubclassFormula(string3, string5);
            } else if (string4.equals("sp")) {
                string2 = this.getSubpropertyFormula(string3, string5);
            } else if (string4.equals("dom")) {
                string2 = this.getDomFormula(string3, string5);
            } else if (string4.equals("range")) {
                string2 = this.getRangeFormula(string3, string5);
            } else if (string4.equals("equiv")) {
                string2 = this.getEquivFormula(string3, string5);
            }
        }
        return string2;
    }

    private String getEquivFormula(String string, String string2) {
        String string3 = this.genVarName();
        this.muVars.add(string3);
        return "(let " + string3 + " = nu (" + string + " <-> " + string2 + ")  & ([d]" + string3 + " & [s]" + string3 + " & [-s]" + string3 + " & [p]" + string3 + " & [-p]" + string3 + " & [o]" + string3 + " & [-o]" + string3 + ") in " + string3 + " end)";
    }

    private String getSubclassFormula(String string, String string2) {
        String string3 = this.genVarName();
        this.muVars.add(string3);
        return "(let " + string3 + " = nu (" + string + " -> " + string2 + ")  & ([d]" + string3 + " & [s]" + string3 + " & [-s]" + string3 + " & [p]" + string3 + " & [-p]" + string3 + " & [o]" + string3 + " & [-o]" + string3 + ") in " + string3 + " end)";
    }

    private String getSubpropertyFormula(String string, String string2) {
        String string3 = this.genVarName();
        this.muVars.add(string3);
        return "(let " + string3 + " = nu (" + string + " -> " + string2 + ")  & ([d]" + string3 + " & [-s]" + string3 + " & [p]" + string3 + " & [o]" + string3 + ") in " + string3 + " end)";
    }

    private String getDomFormula(String string, String string2) {
        String string3 = this.genVarName();
        this.muVars.add(string3);
        return "(let " + string3 + " = nu (<s>(<p>" + string + " -> <p>type & <o>" + string2 + "))  & ([d]" + string3 + " & [s]" + string3 + " & [-s]" + string3 + " & [p]" + string3 + " & [-p]" + string3 + " & [o]" + string3 + " & [-o]" + string3 + ") in " + string3 + " end)";
    }

    private String getRangeFormula(String string, String string2) {
        String string3 = this.genVarName();
        this.muVars.add(string3);
        return "(let " + string3 + " = nu (<-o><p>" + string + " -> <s>(<p>type & <o>" + string2 + "))  & ([d]" + string3 + " & [s]" + string3 + " & [-s]" + string3 + " & [p]" + string3 + " & [-p]" + string3 + " & [o]" + string3 + " & [-o]" + string3 + ") in " + string3 + " end)";
    }

    protected String conjunctEncodingOfAxioms(List<String> list) {
        String string = "";
        if (!list.isEmpty()) {
            string = string + list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                string = string + " & " + list.get(i);
            }
        }
        return string;
    }

    private void createEncoding() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.axiom == null && this.axioms == null) {
            return;
        }
        if (this.axiom != null) {
            arrayList.add(this.getEncoding(this.getAxiom()));
        } else if (this.axioms != null) {
            for (String string : this.axioms) {
                arrayList.add(this.getEncoding(string));
            }
        }
        this.setFormula(this.conjunctEncodingOfAxioms(arrayList));
    }

    private void setFormula(String string) {
        this.phiC = string;
    }

    @Override
    public String getFormula() {
        return this.phiC;
    }

    @Override
    protected String formatSubject(Triple triple) {
        return null;
    }

    @Override
    protected String formatPredicate(Triple triple) {
        return null;
    }

    @Override
    protected String formatObject(Triple triple) {
        return null;
    }
}

