/*
 * Decompiled with CFR 0.152.
 */
package fr.inrialpes.tyrexmo.qcwrapper.afmu;

import afreemu.formula.Closure;
import afreemu.formula.Formula;
import afreemu.formula.SatCheck;
import afreemu.parser.AFEParser;
import afreemu.parser.ASTroot;
import afreemu.parser.ParseException;
import afreemu.util.TimeHistory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.rdf.model.Model;
import fr.inrialpes.tyrexmo.qcwrapper.afmu.AxiomEncoder;
import fr.inrialpes.tyrexmo.qcwrapper.afmu.EncodeLHSQuery;
import fr.inrialpes.tyrexmo.qcwrapper.afmu.EncodeRHSQuery;
import fr.inrialpes.tyrexmo.queryanalysis.CycleAnalysis;
import fr.inrialpes.tyrexmo.queryanalysis.TransformAlgebra;
import fr.inrialpes.tyrexmo.testqc.ContainmentSolver;
import fr.inrialpes.tyrexmo.testqc.ContainmentTestException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AFMUContainmentWrapper
implements ContainmentSolver {
    static final Logger logger = LoggerFactory.getLogger(AFMUContainmentWrapper.class);
    protected static boolean firstTime = true;
    protected static AFEParser parser;
    private String theta = "<-s>spr & <p>spr & <o>spr & !<s>true & !<-p>true & !<-o>true";
    private String eta = "!<-s>true & !<o>true & !<p>true & !<d>true & !<-d>true & !<s>spr & !<-p>spr & !<-o>spr";
    private String kappa = "[-s](" + this.eta + ") & [p](" + this.eta + ") & [o](" + this.eta + ")";
    private static int recVarRank;
    private String WarmupFormula = "((let v1 = mu ((<-s>varx & <p>takescourse & <o>course10))  | <d>v1 in v1 end) & (let v0 = mu ((<-s>varx & <p>takescourse & <o>course20))  | <d>v0 in v0 end)) & !((let v2 = mu ((<-s>varx & <p>takescourse & <o>course10))  | <d>v2 in v2 end))";

    protected String getPhiR() {
        return "(let xp" + ++recVarRank + " = nu " + this.theta + " & " + this.kappa + " & (!<d>true | <d>xp" + recVarRank + ") in xp" + recVarRank + " end)";
    }

    @Override
    public void warmup() {
        try {
            this.checkSAT(this.WarmupFormula);
        }
        catch (Exception exception) {
            logger.warn("Warm-up problem", (Throwable)exception);
        }
    }

    @Override
    public boolean entailed(Query query, Query query2) throws ContainmentTestException {
        return this.entailedUnderSchema((String)null, query, query2);
    }

    @Override
    public boolean entailedUnderSchema(Model model, Query query, Query query2) throws ContainmentTestException {
        throw new ContainmentTestException("Cannot deal with schema");
    }

    @Override
    public boolean entailedUnderSchema(String string, Query query, Query query2) throws ContainmentTestException {
        String string2;
        String string3;
        if (this.supportedTest(query, query2)) {
            if (this.useSameEncoding(query, query2)) {
                string3 = new EncodeLHSQuery(query).getFormula();
                string2 = new EncodeLHSQuery(query).getFormula();
            } else {
                string3 = new EncodeLHSQuery(query).getFormula();
                string2 = new EncodeRHSQuery(query2).getFormula();
            }
        } else {
            throw new ContainmentTestException("Cannot deal with such a test");
        }
        String string4 = this.getPhiR() + " & (" + string3 + ") & !(" + string2 + ")";
        if (string != null) {
            string4 = new AxiomEncoder().encodeSchema(string) + " & (" + string4 + ")";
        }
        try {
            return this.checkSAT(string4);
        }
        catch (Exception exception) {
            throw new ContainmentTestException("Error during Parsing formula", exception);
        }
    }

    @Override
    public void cleanup() {
    }

    public boolean checkSAT(String string) throws ParseException {
        TimeHistory.start();
        if (firstTime) {
            parser = new AFEParser((Reader)new StringReader(string));
            firstTime = false;
        } else {
            AFEParser.ReInit((Reader)new StringReader(string));
        }
        ASTroot aSTroot = (ASTroot)parser.root();
        Formula formula = aSTroot.toFormula();
        Closure closure = new Closure(formula);
        SatCheck satCheck = new SatCheck(formula);
        return !satCheck.satisfiable();
    }

    protected boolean useSameEncoding(Query query, Query query2) {
        return query.equals((Object)query2);
    }

    private boolean supportedTest(Query query, Query query2) {
        TransformAlgebra transformAlgebra = new TransformAlgebra(query);
        TransformAlgebra transformAlgebra2 = new TransformAlgebra(query2);
        return !this.containsOptional(transformAlgebra, transformAlgebra2) && !this.isValidQueryType(query, query2) && !this.isCyclic(transformAlgebra, transformAlgebra2) && !this.haveSameDistVar(query, query2);
    }

    private boolean containsOptional(TransformAlgebra transformAlgebra, TransformAlgebra transformAlgebra2) {
        return transformAlgebra.containsOpt() || transformAlgebra2.containsOpt();
    }

    private boolean isValidQueryType(Query query, Query query2) {
        return query.isConstructType() || query2.isConstructType() || query.isDescribeType() || query2.isDescribeType();
    }

    private boolean isCyclic(TransformAlgebra transformAlgebra, TransformAlgebra transformAlgebra2) {
        CycleAnalysis cycleAnalysis = new CycleAnalysis(transformAlgebra.getTriples());
        CycleAnalysis cycleAnalysis2 = new CycleAnalysis(transformAlgebra2.getTriples());
        return cycleAnalysis.isCyclic() || cycleAnalysis2.isCyclic();
    }

    private boolean haveSameDistVar(Query query, Query query2) {
        List list = query2.getResultVars();
        Collections.sort(list);
        List list2 = query.getResultVars();
        Collections.sort(list2);
        return !((Object)list).equals(list2);
    }

    static {
        recVarRank = 0;
    }
}

