/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.webservices.wsn;

import fr.inria.eventcloud.EventCloudsRegistry;
import fr.inria.eventcloud.api.EventCloudId;
import fr.inria.eventcloud.exceptions.EventCloudIdNotManaged;
import fr.inria.eventcloud.factories.EventCloudsRegistryFactory;
import fr.inria.eventcloud.proxies.PublishProxy;
import fr.inria.eventcloud.proxies.SubscribeProxy;
import fr.inria.eventcloud.translators.wsn.WsnTranslator;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.objectweb.proactive.extensions.p2p.structured.utils.ComponentUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WsnService<T> {
    protected static Logger log = LoggerFactory.getLogger(WsnService.class);
    protected final String registryUrl;
    protected final String streamUrl;
    protected T proxy;
    protected final WsnTranslator translator;

    public WsnService(String registryUrl, String streamUrl) {
        this.registryUrl = registryUrl;
        this.streamUrl = streamUrl;
        this.translator = new WsnTranslator();
    }

    @PostConstruct
    public void init() {
        try {
            this.proxy = this.createProxy();
            log.info("{} proxy deployed", (Object)this.proxy.getClass().getName());
        }
        catch (EventCloudIdNotManaged e) {
            throw new IllegalStateException(e);
        }
    }

    public abstract T createProxy() throws EventCloudIdNotManaged;

    public void terminateProxy() {
        try {
            EventCloudsRegistry registry = EventCloudsRegistryFactory.lookupEventCloudsRegistry((String)this.registryUrl);
            EventCloudId id = new EventCloudId(this.streamUrl);
            if (this.proxy instanceof PublishProxy) {
                registry.unregisterProxy(id, (PublishProxy)this.proxy);
            } else if (this.proxy instanceof SubscribeProxy) {
                registry.unregisterProxy(id, (SubscribeProxy)this.proxy);
            } else {
                WsnService.logAndThrowIllegalArgumentException("Unknow proxy type: " + this.proxy.getClass());
            }
            ComponentUtils.terminateComponent(this.proxy);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static final void logAndThrowIllegalArgumentException(String msg) {
        log.error(msg);
        throw new IllegalArgumentException(msg);
    }
}

