/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.webservices.wsn;

import fr.inria.eventcloud.api.EventCloudId;
import fr.inria.eventcloud.api.SubscribeApi;
import fr.inria.eventcloud.api.Subscription;
import fr.inria.eventcloud.api.SubscriptionId;
import fr.inria.eventcloud.api.listeners.CompoundEventNotificationListener;
import fr.inria.eventcloud.api.properties.AlterableElaProperty;
import fr.inria.eventcloud.exceptions.EventCloudIdNotManaged;
import fr.inria.eventcloud.factories.ProxyFactory;
import fr.inria.eventcloud.translators.wsn.TranslationException;
import fr.inria.eventcloud.translators.wsn.WsnHelper;
import fr.inria.eventcloud.translators.wsn.WsnLogUtils;
import fr.inria.eventcloud.webservices.api.SubscribeWsnApi;
import fr.inria.eventcloud.webservices.listeners.WsnCompoundEventNotificationListener;
import fr.inria.eventcloud.webservices.wsn.WsnService;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.oasis_open.docs.wsn.b_2.GetCurrentMessage;
import org.oasis_open.docs.wsn.b_2.GetCurrentMessageResponse;
import org.oasis_open.docs.wsn.b_2.Renew;
import org.oasis_open.docs.wsn.b_2.RenewResponse;
import org.oasis_open.docs.wsn.b_2.Subscribe;
import org.oasis_open.docs.wsn.b_2.SubscribeResponse;
import org.oasis_open.docs.wsn.b_2.Unsubscribe;
import org.oasis_open.docs.wsn.b_2.UnsubscribeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscribeWsnServiceImpl
extends WsnService<SubscribeApi>
implements SubscribeWsnApi {
    private final Map<SubscriptionId, String> subscribers = new HashMap<SubscriptionId, String>();
    private static final Logger log = LoggerFactory.getLogger(SubscribeWsnServiceImpl.class);

    public SubscribeWsnServiceImpl(String registryUrl, String streamUrl) {
        super(registryUrl, streamUrl);
    }

    @Override
    public SubscribeApi createProxy() throws EventCloudIdNotManaged {
        return ProxyFactory.newSubscribeProxy((String)this.registryUrl, (EventCloudId)new EventCloudId(this.streamUrl), (AlterableElaProperty[])new AlterableElaProperty[0]);
    }

    public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage currentMessage) {
        throw new UnsupportedOperationException();
    }

    public SubscribeResponse subscribe(Subscribe subscribe) {
        if (this.proxy == null) {
            return null;
        }
        WsnLogUtils.logSubscribe((Subscribe)subscribe);
        W3CEndpointReference consumerReference = subscribe.getConsumerReference();
        if (consumerReference != null) {
            String subscriberWsEndpointUrl = WsnHelper.getAddress((W3CEndpointReference)consumerReference);
            if (subscriberWsEndpointUrl != null) {
                try {
                    String sparqlQuery = this.translator.translate(subscribe);
                    log.info("Subscriber endpoint is {}", (Object)subscriberWsEndpointUrl);
                    log.info("Translation output:\n{}", (Object)sparqlQuery);
                    Subscription subscription = new Subscription(sparqlQuery, subscriberWsEndpointUrl);
                    this.subscribers.put(subscription.getId(), subscriberWsEndpointUrl);
                    ((SubscribeApi)this.proxy).subscribe(subscription, (CompoundEventNotificationListener)new WsnCompoundEventNotificationListener(this.streamUrl, subscriberWsEndpointUrl));
                    return WsnHelper.createSubscribeResponse((SubscriptionId)subscription.getId(), (String)subscriberWsEndpointUrl);
                }
                catch (TranslationException e) {
                    log.error("Translation error:");
                    SubscribeWsnServiceImpl.logAndThrowIllegalArgumentException(e.getMessage());
                }
            } else {
                SubscribeWsnServiceImpl.logAndThrowIllegalArgumentException("Subscribe message received but no subscriber address is specified: the subscriber cannot receive any notification");
            }
        } else {
            SubscribeWsnServiceImpl.logAndThrowIllegalArgumentException("Subscribe message does not contain consumer reference");
        }
        return WsnHelper.createSubscribeResponse((String)"http://eventcloud.inria.fr/notification:NotificationService@Endpoint");
    }

    public RenewResponse renew(Renew renewRequest) {
        throw new UnsupportedOperationException();
    }

    public UnsubscribeResponse unsubscribe(Unsubscribe unsubscribeRequest) {
        ((SubscribeApi)this.proxy).unsubscribe(WsnHelper.getSubcriptionId((Unsubscribe)unsubscribeRequest));
        return new UnsubscribeResponse();
    }
}

