/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.webservices.wsn;

import fr.inria.eventcloud.api.CompoundEvent;
import fr.inria.eventcloud.api.EventCloudId;
import fr.inria.eventcloud.api.PublishApi;
import fr.inria.eventcloud.exceptions.EventCloudIdNotManaged;
import fr.inria.eventcloud.factories.ProxyFactory;
import fr.inria.eventcloud.translators.wsn.TranslationException;
import fr.inria.eventcloud.translators.wsn.WsnLogUtils;
import fr.inria.eventcloud.webservices.api.PublishWsnApi;
import fr.inria.eventcloud.webservices.wsn.WsnService;
import org.oasis_open.docs.wsn.b_2.NotificationMessageHolderType;
import org.oasis_open.docs.wsn.b_2.Notify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishWsnServiceImpl
extends WsnService<PublishApi>
implements PublishWsnApi {
    private static final Logger log = LoggerFactory.getLogger(PublishWsnServiceImpl.class);

    public PublishWsnServiceImpl(String registryUrl, String streamUrl) {
        super(registryUrl, streamUrl);
    }

    @Override
    public PublishApi createProxy() throws EventCloudIdNotManaged {
        return ProxyFactory.newPublishProxy((String)this.registryUrl, (EventCloudId)new EventCloudId(this.streamUrl));
    }

    public void notify(Notify notify) {
        if (this.proxy == null) {
            return;
        }
        if (notify.getNotificationMessage().size() > 0) {
            for (NotificationMessageHolderType notificationMessage : notify.getNotificationMessage()) {
                try {
                    WsnLogUtils.logNotificationMessageHolderType((NotificationMessageHolderType)notificationMessage);
                    CompoundEvent compoundEvent = this.translator.translate(notificationMessage);
                    log.info("Translation output:\n{}", (Object)compoundEvent);
                    ((PublishApi)this.proxy).publish(compoundEvent);
                }
                catch (TranslationException e) {
                    log.error("Translation error", (Throwable)e);
                }
            }
        } else {
            log.error("Notify message received does not contain any notification message");
        }
    }
}

