/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.webservices.monitoring;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import easybox.petalslink.com.esrawreport._1.EJaxbReportListType;
import easybox.petalslink.com.esrawreport._1.EJaxbReportTimeStampType;
import easybox.petalslink.com.esrawreport._1.EJaxbReportType;
import easybox.petalslink.com.esrawreport._1.ObjectFactory;
import fr.inria.eventcloud.api.SubscriptionId;
import fr.inria.eventcloud.configuration.EventCloudProperties;
import fr.inria.eventcloud.monitoring.ProxyMonitoringActions;
import fr.inria.eventcloud.translators.wsn.WsnHelper;
import fr.inria.eventcloud.webservices.factories.WsClientFactory;
import fr.inria.eventcloud.webservices.monitoring.ProxyMonitoringManager;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.oasis_open.docs.wsn.b_2.Notify;
import org.oasis_open.docs.wsn.bw_2.NotificationConsumer;
import org.objectweb.proactive.Body;
import org.objectweb.proactive.Service;
import org.objectweb.proactive.core.component.body.ComponentInitActive;
import org.objectweb.proactive.extensions.p2p.structured.AbstractComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ProxyMonitoringManagerImpl
extends AbstractComponent
implements ProxyMonitoringActions,
ProxyMonitoringManager,
ComponentInitActive {
    public static final String COMPONENT_NAME = "ProxyMonitoringManager";
    public static final String PROXY_MONITORING_MANAGER_ADL = "fr.inria.eventcloud.webservices.monitoring.ProxyMonitoringManager";
    public static final String MONITORING_SERVICES_ITF = "monitoring-services";
    private static final QName RAW_REPORT_QNAME = new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic", "rrt");
    private static final QName INTERFACE_QNAME = new QName("http://www.petalslink.com/wsn/service/WsnProducer", "NotificationProducer", "np");
    public final LoadingCache<String, NotificationConsumer> notificationConsumerClients = CacheBuilder.newBuilder().softValues().maximumSize(10L).build((CacheLoader)new CacheLoader<String, NotificationConsumer>(){

        public NotificationConsumer load(String consumerEndpoint) throws Exception {
            return WsClientFactory.createWsClient(NotificationConsumer.class, consumerEndpoint);
        }
    });
    private Map<SubscriptionId, String> consumerEndpoints;
    private ExecutorService cachedThreadPool;

    public void initComponentActivity(Body body) {
        this.configurationProperty = "eventcloud.configuration";
        this.propertiesClass = EventCloudProperties.class;
        super.initComponentActivity(body);
        this.consumerEndpoints = new HashMap<SubscriptionId, String>();
    }

    public void runComponentActivity(Body body) {
        new Service(body).fifoServing();
    }

    @Override
    public boolean enableInputOutputMonitoring(SubscriptionId subscriptionId, String consumerEndpoint) {
        if (!this.consumerEndpoints.containsValue(consumerEndpoint)) {
            this.consumerEndpoints.put(subscriptionId, consumerEndpoint);
            return true;
        }
        return false;
    }

    @Override
    public boolean disableInputOutputMonitoring(SubscriptionId subscriptionId) {
        if (this.consumerEndpoints.containsKey(subscriptionId)) {
            this.consumerEndpoints.remove(subscriptionId);
            return true;
        }
        return false;
    }

    @Override
    public boolean isInputOutputMonitoringEnabled() {
        return this.consumerEndpoints.size() > 0;
    }

    public void sendInputOutputMonitoringReport(final String source, final String destination, final long eventPublicationTimestamp) {
        for (final String consumerEndpoint : this.consumerEndpoints.values()) {
            this.getCachedThreadPool().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ((NotificationConsumer)ProxyMonitoringManagerImpl.this.notificationConsumerClients.get((Object)consumerEndpoint)).notify(ProxyMonitoringManagerImpl.createRawReport(consumerEndpoint, source, destination, eventPublicationTimestamp));
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    private synchronized ExecutorService getCachedThreadPool() {
        if (this.cachedThreadPool == null) {
            this.cachedThreadPool = Executors.newCachedThreadPool();
        }
        return this.cachedThreadPool;
    }

    private static Notify createRawReport(String consumerEndpoint, String source, String destination, long eventPublicationTimestamp) {
        ObjectFactory factory = new ObjectFactory();
        EJaxbReportType reportType = factory.createEJaxbReportType();
        reportType.setExchangeId(UUID.randomUUID().toString());
        reportType.setTimeStamp(EJaxbReportTimeStampType.T_1);
        try {
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTimeInMillis(eventPublicationTimestamp);
            reportType.setDateInGMT(DatatypeFactory.newInstance().newXMLGregorianCalendar(gc));
        }
        catch (DatatypeConfigurationException e) {
            throw new IllegalStateException(e);
        }
        reportType.setConsumerEndpointAddress(destination);
        reportType.setOperationName("http://com.petalslink.esstar/service/management/user/1.0/Notify");
        reportType.setInterfaceQName(INTERFACE_QNAME);
        reportType.setProviderEndpointAddress(source);
        reportType.setContentLength(-1L);
        reportType.setDoesThisResponseIsAnException(false);
        reportType.setEndpointName("EventCloud");
        EJaxbReportListType reportTypeList = factory.createEJaxbReportListType();
        reportTypeList.getReport().add(reportType);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            Document doc = dbf.newDocumentBuilder().newDocument();
            JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class}).createMarshaller().marshal((Object)factory.createReportList(reportTypeList), (Node)doc);
            return WsnHelper.createNotifyMessage((String)consumerEndpoint, (QName)RAW_REPORT_QNAME, (String)source, (Object)doc.getDocumentElement());
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }
}

