/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.webservices.listeners;

import fr.inria.eventcloud.api.CompoundEvent;
import fr.inria.eventcloud.api.SubscriptionId;
import fr.inria.eventcloud.api.listeners.CompoundEventNotificationListener;
import fr.inria.eventcloud.translators.wsn.TranslationException;
import fr.inria.eventcloud.translators.wsn.WsnHelper;
import fr.inria.eventcloud.webservices.factories.WsClientFactory;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.oasis_open.docs.wsn.bw_2.NotificationConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsnCompoundEventNotificationListener
extends CompoundEventNotificationListener {
    private static final long serialVersionUID = 130L;
    private static final Logger log = LoggerFactory.getLogger(WsnCompoundEventNotificationListener.class);
    private final QName streamQName;
    private final String subscriberWsEndpointUrl;
    private transient NotificationConsumer subscriberWsClient;

    public WsnCompoundEventNotificationListener(String streamUrl, String subscriberWsEndpointUrl) {
        this.subscriberWsEndpointUrl = subscriberWsEndpointUrl;
        int index = streamUrl.lastIndexOf(47);
        this.streamQName = new QName(streamUrl.substring(0, index), streamUrl.substring(index + 1), "s");
    }

    private synchronized NotificationConsumer getSubscriberWsClient() {
        if (this.subscriberWsClient == null) {
            this.subscriberWsClient = WsClientFactory.createWsClient(NotificationConsumer.class, this.subscriberWsEndpointUrl);
        }
        return this.subscriberWsClient;
    }

    public void onNotification(SubscriptionId id, CompoundEvent solution) {
        try {
            this.getSubscriberWsClient().notify(WsnHelper.createNotifyMessage((String)this.subscriberWsEndpointUrl, (QName)this.streamQName, (CompoundEvent[])new CompoundEvent[]{solution}));
            log.info("Subscriber {} notified about:\n {}", (Object)this.subscriberWsEndpointUrl, (Object)solution);
        }
        catch (TranslationException e) {
            log.error("Error during translation", (Throwable)e);
        }
        catch (WebServiceException e) {
            log.error("Failed to send notification to " + this.subscriberWsEndpointUrl, e.getCause());
        }
    }

    public String getSubscriberUrl() {
        return this.subscriberWsEndpointUrl;
    }
}

