/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.webservices.listeners;

import fr.inria.eventcloud.api.SubscriptionId;
import fr.inria.eventcloud.api.listeners.SignalNotificationListener;
import fr.inria.eventcloud.webservices.api.subscribers.SignalSubscriberWsApi;
import fr.inria.eventcloud.webservices.factories.WsClientFactory;
import javax.xml.ws.WebServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsSignalNotificationListener
extends SignalNotificationListener {
    private static final long serialVersionUID = 130L;
    private static final Logger log = LoggerFactory.getLogger(WsSignalNotificationListener.class);
    private final String subscriberWsEndpointUrl;
    private SignalSubscriberWsApi subscriberWsClient;

    public WsSignalNotificationListener(String subscriberWsEndpointUrl) {
        this.subscriberWsEndpointUrl = subscriberWsEndpointUrl;
        this.subscriberWsClient = WsClientFactory.createWsClient(SignalSubscriberWsApi.class, this.subscriberWsEndpointUrl);
    }

    public void onNotification(SubscriptionId id) {
        try {
            this.subscriberWsClient.notifySignal(id.toString());
            log.info("Subscriber {} notified about solution", (Object)this.subscriberWsEndpointUrl);
        }
        catch (WebServiceException e) {
            log.error("Failed to send notification to " + this.subscriberWsEndpointUrl, e.getCause());
        }
    }

    public String getSubscriberUrl() {
        return this.subscriberWsEndpointUrl;
    }
}

