/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.webservices.listeners;

import fr.inria.eventcloud.api.CompoundEvent;
import fr.inria.eventcloud.api.SubscriptionId;
import fr.inria.eventcloud.api.listeners.CompoundEventNotificationListener;
import fr.inria.eventcloud.webservices.api.subscribers.CompoundEventSubscriberWsApi;
import fr.inria.eventcloud.webservices.factories.WsClientFactory;
import javax.xml.ws.WebServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsCompoundEventNotificationListener
extends CompoundEventNotificationListener {
    private static final long serialVersionUID = 130L;
    private static final Logger log = LoggerFactory.getLogger(WsCompoundEventNotificationListener.class);
    private final String subscriberWsEndpointUrl;
    private CompoundEventSubscriberWsApi subscriberWsClient;

    public WsCompoundEventNotificationListener(String subscriberWsEndpointUrl) {
        this.subscriberWsEndpointUrl = subscriberWsEndpointUrl;
        this.subscriberWsClient = WsClientFactory.createWsClient(CompoundEventSubscriberWsApi.class, this.subscriberWsEndpointUrl);
    }

    public void onNotification(SubscriptionId id, CompoundEvent event) {
        try {
            this.subscriberWsClient.notifyCompoundEvent(id.toString(), event);
            log.info("Subscriber {} notified about:\n {}", (Object)this.subscriberWsEndpointUrl, (Object)event);
        }
        catch (WebServiceException e) {
            log.error("Failed to send notification to " + this.subscriberWsEndpointUrl, e.getCause());
        }
    }

    public String getSubscriberUrl() {
        return this.subscriberWsEndpointUrl;
    }
}

