/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.webservices.listeners;

import com.hp.hpl.jena.sparql.engine.binding.Binding;
import fr.inria.eventcloud.api.SubscriptionId;
import fr.inria.eventcloud.api.listeners.BindingNotificationListener;
import fr.inria.eventcloud.api.wrappers.BindingWrapper;
import fr.inria.eventcloud.webservices.api.subscribers.BindingSubscriberWsApi;
import fr.inria.eventcloud.webservices.factories.WsClientFactory;
import javax.xml.ws.WebServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsBindingNotificationListener
extends BindingNotificationListener {
    private static final long serialVersionUID = 130L;
    private static final Logger log = LoggerFactory.getLogger(WsBindingNotificationListener.class);
    private final String subscriberWsEndpointUrl;
    private BindingSubscriberWsApi subscriberWsClient;

    public WsBindingNotificationListener(String subscriberWsEndpointUrl) {
        this.subscriberWsEndpointUrl = subscriberWsEndpointUrl;
        this.subscriberWsClient = WsClientFactory.createWsClient(BindingSubscriberWsApi.class, this.subscriberWsEndpointUrl);
    }

    public void onNotification(SubscriptionId id, Binding binding) {
        try {
            this.subscriberWsClient.notifyBinding(id.toString(), new BindingWrapper(binding));
            log.info("Subscriber {} notified about:\n {}", (Object)this.subscriberWsEndpointUrl, (Object)binding);
        }
        catch (WebServiceException e) {
            log.error("Failed to send notification to " + this.subscriberWsEndpointUrl, e.getCause());
        }
    }

    public String getSubscriberUrl() {
        return this.subscriberWsEndpointUrl;
    }
}

