/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.webservices.deployment;

import fr.inria.eventcloud.EventCloudsRegistry;
import fr.inria.eventcloud.api.EventCloudId;
import fr.inria.eventcloud.factories.EventCloudsRegistryFactory;
import fr.inria.eventcloud.proxies.Proxy;
import fr.inria.eventcloud.proxies.PublishProxy;
import fr.inria.eventcloud.proxies.PutGetProxy;
import fr.inria.eventcloud.proxies.SubscribeProxy;
import fr.inria.eventcloud.webservices.deployment.WsDeployer;
import fr.inria.eventcloud.webservices.deployment.WsInfo;
import java.io.IOException;
import org.objectweb.proactive.extensions.p2p.structured.utils.ComponentUtils;

public class WsProxyInfo
extends WsInfo {
    private final String registryUrl;
    private final Proxy proxy;
    private final String proxyName;
    private final String interfaceName;

    public WsProxyInfo(String streamUrl, String wsEndpointUrl, String registryUrl, Proxy proxy, String proxyName, String interfaceName) {
        super(streamUrl, wsEndpointUrl);
        this.registryUrl = registryUrl;
        this.proxy = proxy;
        this.proxyName = proxyName;
        this.interfaceName = interfaceName;
    }

    public String getRegistryUrl() {
        return this.registryUrl;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public String getProxyName() {
        return this.proxyName;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    @Override
    public void destroy() {
        WsDeployer.unexposeWebService(this.proxy, this.proxyName, this.interfaceName);
        try {
            EventCloudsRegistry registry = EventCloudsRegistryFactory.lookupEventCloudsRegistry((String)this.registryUrl);
            EventCloudId eventCloudId = new EventCloudId(this.streamUrl);
            if (this.proxy instanceof PublishProxy) {
                registry.unregisterProxy(eventCloudId, (PublishProxy)this.proxy);
            } else if (this.proxy instanceof SubscribeProxy) {
                registry.unregisterProxy(eventCloudId, (SubscribeProxy)this.proxy);
            } else if (this.proxy instanceof PutGetProxy) {
                registry.unregisterProxy(eventCloudId, (PutGetProxy)this.proxy);
            } else {
                throw new IllegalArgumentException("Unknow proxy type: " + this.proxy.getClass());
            }
            ComponentUtils.terminateComponent((Object)this.proxy);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }
}

