/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.webservices.deployment;

import fr.inria.eventcloud.api.EventCloudId;
import fr.inria.eventcloud.api.PublishApi;
import fr.inria.eventcloud.api.PutGetApi;
import fr.inria.eventcloud.api.SubscribeApi;
import fr.inria.eventcloud.api.properties.AlterableElaProperty;
import fr.inria.eventcloud.exceptions.EventCloudIdNotManaged;
import fr.inria.eventcloud.proxies.Proxy;
import fr.inria.eventcloud.webservices.EventCloudsManagementServiceImpl;
import fr.inria.eventcloud.webservices.api.EventCloudsManagementWsnApi;
import fr.inria.eventcloud.webservices.api.PublishWsnApi;
import fr.inria.eventcloud.webservices.api.SubscribeWsnApi;
import fr.inria.eventcloud.webservices.deployment.WsProxyInfo;
import fr.inria.eventcloud.webservices.deployment.WsnServiceInfo;
import fr.inria.eventcloud.webservices.factories.WsProxyFactory;
import fr.inria.eventcloud.webservices.wsn.PublishWsnServiceImpl;
import fr.inria.eventcloud.webservices.wsn.SubscribeWsnServiceImpl;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.Interface;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.proactive.ActiveObjectCreationException;
import org.objectweb.proactive.core.node.Node;
import org.objectweb.proactive.core.node.NodeException;
import org.objectweb.proactive.extensions.webservices.component.Utils;
import org.objectweb.proactive.extensions.webservices.component.controller.PAWebServicesController;
import org.objectweb.proactive.extensions.webservices.exceptions.WebServicesException;

public class WsDeployer {
    private static final String DEFAULT_IP = "0.0.0.0";

    public static Server deployEventCloudsManagementService(String registryUrl, String urlSuffix, int port) {
        return WsDeployer.deployWebService(EventCloudsManagementWsnApi.class, new EventCloudsManagementServiceImpl(registryUrl, port), urlSuffix, port);
    }

    public static WsnServiceInfo deployPublishWsnService(String registryUrl, String streamUrl, String urlSuffix, int port) {
        PublishWsnServiceImpl publishWsnService = new PublishWsnServiceImpl(registryUrl, streamUrl);
        Server publishWsnServer = WsDeployer.deployWebService(PublishWsnApi.class, publishWsnService, urlSuffix, port);
        return new WsnServiceInfo(streamUrl, WsDeployer.getEndpointUrl(publishWsnServer), publishWsnService, publishWsnServer);
    }

    public static WsnServiceInfo deploySubscribeWsnService(String registryUrl, String streamUrl, String urlSuffix, int port) {
        SubscribeWsnServiceImpl subscribeService = new SubscribeWsnServiceImpl(registryUrl, streamUrl);
        Server server = WsDeployer.deployWebService(SubscribeWsnApi.class, subscribeService, urlSuffix, port);
        return new WsnServiceInfo(streamUrl, WsDeployer.getEndpointUrl(server), subscribeService, server);
    }

    public static String getEndpointUrl(Server server) {
        String endpointUrl = server.getEndpoint().getEndpointInfo().getAddress();
        if (endpointUrl.contains(DEFAULT_IP)) {
            try {
                endpointUrl = endpointUrl.replaceFirst(DEFAULT_IP, InetAddress.getLocalHost().getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return endpointUrl;
    }

    public static Server deployWebService(Object service, String urlSuffix, int port) {
        return WsDeployer.deployWebService(service.getClass(), service, urlSuffix, port);
    }

    public static Server deployWebService(Class<?> serviceClass, Object service, String urlSuffix, int port) {
        StringBuilder address = new StringBuilder("http://");
        address.append(DEFAULT_IP);
        address.append(':');
        address.append(port);
        address.append('/');
        if (urlSuffix != null) {
            address.append(urlSuffix);
        }
        JaxWsServerFactoryBean serverFactoryBean = new JaxWsServerFactoryBean();
        serverFactoryBean.setServiceClass(serviceClass);
        serverFactoryBean.setAddress(address.toString());
        serverFactoryBean.setServiceBean(service);
        LoggingInInterceptor in = new LoggingInInterceptor();
        serverFactoryBean.getInInterceptors().add(in);
        serverFactoryBean.getInFaultInterceptors().add(in);
        LoggingOutInterceptor out = new LoggingOutInterceptor();
        serverFactoryBean.getOutInterceptors().add(out);
        serverFactoryBean.getOutFaultInterceptors().add(out);
        return serverFactoryBean.create();
    }

    public static WsProxyInfo deployPublishWsProxy(String registryUrl, String streamUrl, String proxyName) {
        try {
            PublishApi publishProxy = WsProxyFactory.newPublishProxy(registryUrl, new EventCloudId(streamUrl));
            String endpointUrl = WsDeployer.exposePublishWebService(publishProxy, proxyName);
            return new WsProxyInfo(streamUrl, endpointUrl, registryUrl, (Proxy)publishProxy, proxyName, "publish-webservices");
        }
        catch (EventCloudIdNotManaged e) {
            throw new IllegalStateException(e);
        }
    }

    public static WsProxyInfo deploySubscribeWsProxy(String registryUrl, String streamUrl, String proxyName) {
        try {
            SubscribeApi subscribeProxy = WsProxyFactory.newSubscribeProxy(registryUrl, new EventCloudId(streamUrl), new AlterableElaProperty[0]);
            String endpointUrl = WsDeployer.exposeSubscribeWebService(subscribeProxy, proxyName);
            return new WsProxyInfo(streamUrl, endpointUrl, registryUrl, (Proxy)subscribeProxy, proxyName, "subscribe-webservices");
        }
        catch (EventCloudIdNotManaged e) {
            throw new IllegalStateException(e);
        }
    }

    public static WsProxyInfo deployPutGetWsProxy(String registryUrl, String streamUrl, String proxyName) {
        try {
            PutGetApi putgetProxy = WsProxyFactory.newPutGetProxy(registryUrl, new EventCloudId(streamUrl));
            String endpointUrl = WsDeployer.exposePutGetWebService(putgetProxy, proxyName);
            return new WsProxyInfo(streamUrl, endpointUrl, registryUrl, (Proxy)putgetProxy, proxyName, "putget-webservices");
        }
        catch (EventCloudIdNotManaged e) {
            throw new IllegalStateException(e);
        }
    }

    public static String exposePublishWebService(PublishApi publishProxy, String proxyName) {
        return WsDeployer.exposeWebService((Proxy)publishProxy, proxyName, "publish-webservices");
    }

    public static String exposeSubscribeWebService(SubscribeApi subscribeProxy, String proxyName) {
        return WsDeployer.exposeWebService((Proxy)subscribeProxy, proxyName, "subscribe-webservices");
    }

    public static String exposePutGetWebService(PutGetApi putgetProxy, String proxyName) {
        return WsDeployer.exposeWebService((Proxy)putgetProxy, proxyName, "putget-webservices");
    }

    public static String exposeWebService(Proxy proxy, String proxyName, String interfaceName) {
        try {
            Component proxyComponent = ((Interface)proxy).getFcItfOwner();
            PAWebServicesController wsc = Utils.getPAWebServicesController((Component)proxyComponent);
            wsc.initServlet(new Node[0]);
            wsc.exposeComponentAsWebService(proxyName, new String[]{interfaceName});
            return wsc.getLocalUrl() + "proactive/services/" + proxyName + "_" + interfaceName;
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
        }
        catch (ActiveObjectCreationException e) {
            e.printStackTrace();
        }
        catch (NodeException e) {
            e.printStackTrace();
        }
        catch (WebServicesException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void unexposePublishWebService(PublishApi publishProxy, String proxyName) {
        WsDeployer.unexposeWebService((Proxy)publishProxy, proxyName, "publish-webservices");
    }

    public static void unexposeSubscribeWebService(SubscribeApi subscribeProxy, String proxyName) {
        WsDeployer.unexposeWebService((Proxy)subscribeProxy, proxyName, "subscribe-webservices");
    }

    public static void unexposePutGetWebService(PutGetApi putgetProxy, String proxyName) {
        WsDeployer.unexposeWebService((Proxy)putgetProxy, proxyName, "putget-webservices");
    }

    public static void unexposeWebService(Proxy proxy, String proxyName, String interfaceName) {
        try {
            Component proxyComponent = ((Interface)proxy).getFcItfOwner();
            PAWebServicesController wsc = Utils.getPAWebServicesController((Component)proxyComponent);
            wsc.unExposeComponentAsWebService(proxyName, new String[]{interfaceName});
        }
        catch (NoSuchInterfaceException e) {
            e.printStackTrace();
        }
        catch (WebServicesException e) {
            e.printStackTrace();
        }
    }
}

