/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.webservices;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import fr.inria.eventcloud.EventCloudDescription;
import fr.inria.eventcloud.EventCloudsRegistry;
import fr.inria.eventcloud.api.EventCloudId;
import fr.inria.eventcloud.api.SubscriptionId;
import fr.inria.eventcloud.api.properties.UnalterableElaProperty;
import fr.inria.eventcloud.deployment.EventCloudDeployer;
import fr.inria.eventcloud.deployment.EventCloudDeploymentDescriptor;
import fr.inria.eventcloud.factories.EventCloudsRegistryFactory;
import fr.inria.eventcloud.providers.SemanticPersistentOverlayProvider;
import fr.inria.eventcloud.proxies.SubscribeProxy;
import fr.inria.eventcloud.translators.wsn.WsnHelper;
import fr.inria.eventcloud.webservices.api.EventCloudsManagementWsnApi;
import fr.inria.eventcloud.webservices.deployment.WsDeployer;
import fr.inria.eventcloud.webservices.deployment.WsInfo;
import fr.inria.eventcloud.webservices.deployment.WsProxyInfo;
import fr.inria.eventcloud.webservices.deployment.WsnServiceInfo;
import fr.inria.eventcloud.webservices.factories.ProxyMonitoringManagerFactory;
import fr.inria.eventcloud.webservices.monitoring.ProxyMonitoringManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.xml.namespace.QName;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.etsi.uri.gcm.util.GCM;
import org.oasis_open.docs.wsn.b_2.GetCurrentMessage;
import org.oasis_open.docs.wsn.b_2.GetCurrentMessageResponse;
import org.oasis_open.docs.wsn.b_2.Renew;
import org.oasis_open.docs.wsn.b_2.RenewResponse;
import org.oasis_open.docs.wsn.b_2.Subscribe;
import org.oasis_open.docs.wsn.b_2.SubscribeResponse;
import org.oasis_open.docs.wsn.b_2.Unsubscribe;
import org.oasis_open.docs.wsn.b_2.UnsubscribeResponse;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalContentException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.proactive.core.component.PAInterface;
import org.objectweb.proactive.core.component.Utils;
import org.objectweb.proactive.core.component.control.PAMembraneController;
import org.objectweb.proactive.core.component.exceptions.NoSuchComponentException;
import org.objectweb.proactive.extensions.p2p.structured.providers.SerializableProvider;

public class EventCloudsManagementServiceImpl
implements EventCloudsManagementWsnApi {
    private static final String WSN_SERVICE_ID = "wsn-service-";
    private static final String WS_PROXY_ID = "ws-proxy-";
    private static final String RAW_REPORT_TOPIC = "http://www.petalslink.org/rawreport/1.0/RawReportTopic";
    private final String registryUrl;
    private EventCloudsRegistry registry;
    private final int wsnServicePort;
    private final Map<String, WsInfo> wsInfos;
    private final ListMultimap<String, Integer> assignedNumberIds;
    private final ListMultimap<String, String> publishWsnServiceEndpointUrls;
    private final ListMultimap<String, String> subscribeWsnServiceEndpointUrls;
    private final ListMultimap<String, String> publishWsProxyEndpointUrls;
    private final ListMultimap<String, String> subscribeWsProxyEndpointUrls;
    private final ListMultimap<String, String> putgetWsProxyEndpointUrls;

    public EventCloudsManagementServiceImpl(String registryUrl, int wsnServicePort) {
        this.registryUrl = registryUrl;
        this.wsnServicePort = wsnServicePort;
        this.wsInfos = Maps.newHashMap();
        this.assignedNumberIds = ArrayListMultimap.create();
        this.publishWsnServiceEndpointUrls = ArrayListMultimap.create();
        this.subscribeWsnServiceEndpointUrls = ArrayListMultimap.create();
        this.publishWsProxyEndpointUrls = ArrayListMultimap.create();
        this.subscribeWsProxyEndpointUrls = ArrayListMultimap.create();
        this.putgetWsProxyEndpointUrls = ArrayListMultimap.create();
    }

    @PostConstruct
    public void init() {
        try {
            this.registry = EventCloudsRegistryFactory.lookupEventCloudsRegistry((String)this.registryUrl);
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    public String getRegistryEndpointUrl() {
        return this.registryUrl;
    }

    public boolean createEventCloud(String streamUrl) {
        EventCloudId id = new EventCloudId(streamUrl);
        if (!this.registry.contains(id)) {
            EventCloudDescription description = new EventCloudDescription(id, new UnalterableElaProperty[0]);
            EventCloudDeployer deployer = new EventCloudDeployer(description, new EventCloudDeploymentDescriptor((SerializableProvider)new SemanticPersistentOverlayProvider()));
            deployer.deploy(1, 1);
            return this.registry.register(deployer);
        }
        return false;
    }

    public boolean isCreated(String streamUrl) {
        return this.registry.contains(new EventCloudId(streamUrl));
    }

    public List<String> getEventCloudIds() {
        Set ids = this.registry.listEventClouds();
        ArrayList<String> result = new ArrayList<String>(ids.size());
        for (EventCloudId id : ids) {
            result.add(id.getStreamUrl());
        }
        return result;
    }

    public boolean destroyEventCloud(String streamUrl) {
        EventCloudId id = new EventCloudId(streamUrl);
        if (this.registry.contains(id)) {
            boolean result = true;
            result &= this.destroyWebServices(streamUrl, this.publishWsnServiceEndpointUrls);
            result &= this.destroyWebServices(streamUrl, this.subscribeWsnServiceEndpointUrls);
            result &= this.destroyWebServices(streamUrl, this.publishWsProxyEndpointUrls);
            result &= this.destroyWebServices(streamUrl, this.subscribeWsProxyEndpointUrls);
            return (result &= this.destroyWebServices(streamUrl, this.putgetWsProxyEndpointUrls)) && this.registry.undeploy(id);
        }
        return false;
    }

    private boolean destroyWebServices(String streamUrl, ListMultimap<String, String> wsEndpointUrls) {
        boolean result = true;
        for (String wsEndpointUrl : ImmutableList.copyOf((Collection)wsEndpointUrls.get((Object)streamUrl))) {
            result &= this.destroyWebService(wsEndpointUrl, wsEndpointUrls);
        }
        return result;
    }

    public String deployPublishWsnService(String streamUrl) {
        this.checkEventCloudId(streamUrl);
        int numberId = this.lockUnassignedNumberId(streamUrl);
        WsnServiceInfo publishWsnServiceInfo = WsDeployer.deployPublishWsnService(this.registryUrl, streamUrl, "proactive/services/eventclouds/" + this.getTopicName(streamUrl) + "/" + WSN_SERVICE_ID + numberId + "_publish-webservices", this.wsnServicePort);
        return this.storeAndReturnProxyAddress(publishWsnServiceInfo, this.publishWsnServiceEndpointUrls);
    }

    public String deploySubscribeWsnService(String streamUrl) {
        this.checkEventCloudId(streamUrl);
        int numberId = this.lockUnassignedNumberId(streamUrl);
        WsnServiceInfo subscribeWsnServiceInfo = WsDeployer.deploySubscribeWsnService(this.registryUrl, streamUrl, "proactive/services/eventclouds/" + this.getTopicName(streamUrl) + "/" + WSN_SERVICE_ID + numberId + "_subscribe-webservices", this.wsnServicePort);
        return this.storeAndReturnProxyAddress(subscribeWsnServiceInfo, this.subscribeWsnServiceEndpointUrls);
    }

    public String deployPublishWsProxy(String streamUrl) {
        this.checkEventCloudId(streamUrl);
        int numberId = this.lockUnassignedNumberId(streamUrl);
        WsProxyInfo publishWsProxyInfo = WsDeployer.deployPublishWsProxy(this.registryUrl, streamUrl, "eventclouds/" + this.getTopicName(streamUrl) + "/" + WS_PROXY_ID + numberId);
        return this.storeAndReturnProxyAddress(publishWsProxyInfo, this.publishWsProxyEndpointUrls);
    }

    public String deploySubscribeWsProxy(String streamUrl) {
        this.checkEventCloudId(streamUrl);
        int numberId = this.lockUnassignedNumberId(streamUrl);
        WsProxyInfo subscribeWsProxyInfo = WsDeployer.deploySubscribeWsProxy(this.registryUrl, streamUrl, "eventclouds/" + this.getTopicName(streamUrl) + "/" + WS_PROXY_ID + numberId);
        return this.storeAndReturnProxyAddress(subscribeWsProxyInfo, this.subscribeWsProxyEndpointUrls);
    }

    public String deployPutGetWsProxy(String streamUrl) {
        this.checkEventCloudId(streamUrl);
        int numberId = this.lockUnassignedNumberId(streamUrl);
        WsProxyInfo putgetWsProxyInfo = WsDeployer.deployPutGetWsProxy(this.registryUrl, streamUrl, "eventclouds/" + this.getTopicName(streamUrl) + "/" + WS_PROXY_ID + numberId);
        return this.storeAndReturnProxyAddress(putgetWsProxyInfo, this.putgetWsProxyEndpointUrls);
    }

    private void checkEventCloudId(String streamUrl) {
        EventCloudId id = new EventCloudId(streamUrl);
        if (!this.registry.contains(id)) {
            throw new IllegalArgumentException("No EventCloud running for " + streamUrl);
        }
    }

    private String getTopicName(String streamUrl) {
        return streamUrl.substring(streamUrl.lastIndexOf(47) + 1);
    }

    private int lockUnassignedNumberId(String streamUrl) {
        int numberId = 1;
        ListMultimap<String, Integer> listMultimap = this.assignedNumberIds;
        synchronized (listMultimap) {
            while (true) {
                if (!this.assignedNumberIds.containsEntry((Object)streamUrl, (Object)numberId)) {
                    this.assignedNumberIds.put((Object)streamUrl, (Object)numberId);
                    return numberId;
                }
                ++numberId;
            }
        }
    }

    private String storeAndReturnProxyAddress(WsInfo wsInfo, ListMultimap<String, String> wsEndpointUrls) {
        wsEndpointUrls.put((Object)wsInfo.getStreamUrl(), (Object)wsInfo.getWsEndpointUrl());
        this.wsInfos.put(wsInfo.getWsEndpointUrl(), wsInfo);
        return wsInfo.getWsEndpointUrl();
    }

    public List<String> getPublishWsnServiceEndpointUrls(String streamUrl) {
        return this.publishWsnServiceEndpointUrls.get((Object)streamUrl);
    }

    public List<String> getSubscribeWsnServiceEndpointUrls(String streamUrl) {
        return this.subscribeWsnServiceEndpointUrls.get((Object)streamUrl);
    }

    public List<String> getPublishWsProxyEndpointUrls(String streamUrl) {
        return this.publishWsProxyEndpointUrls.get((Object)streamUrl);
    }

    public List<String> getSubscribeWsProxyEndpointUrls(String streamUrl) {
        return this.subscribeWsProxyEndpointUrls.get((Object)streamUrl);
    }

    public List<String> getPutGetWsProxyEndpointUrls(String streamUrl) {
        return this.putgetWsProxyEndpointUrls.get((Object)streamUrl);
    }

    public boolean destroyPublishWsnService(String publishWsnEndpointUrl) {
        return this.destroyWebService(publishWsnEndpointUrl, this.publishWsnServiceEndpointUrls);
    }

    public boolean destroySubscribeWsnService(String subscribeWsnEndpointUrl) {
        return this.destroyWebService(subscribeWsnEndpointUrl, this.subscribeWsnServiceEndpointUrls);
    }

    public boolean destroyPublishWsProxy(String publishWsProxyEndpointUrl) {
        return this.destroyWebService(publishWsProxyEndpointUrl, this.publishWsProxyEndpointUrls);
    }

    public boolean destroySubscribeWsProxy(String subscribeWsProxyEndpointUrl) {
        return this.destroyWebService(subscribeWsProxyEndpointUrl, this.subscribeWsProxyEndpointUrls);
    }

    public boolean destroyPutGetWsProxy(String putgetWsProxyEndpointUrl) {
        return this.destroyWebService(putgetWsProxyEndpointUrl, this.putgetWsProxyEndpointUrls);
    }

    private boolean destroyWebService(String wsEndpointUrl, ListMultimap<String, String> wsEndpointUrls) {
        WsInfo wsInfo = this.wsInfos.remove(wsEndpointUrl);
        if (wsInfo != null) {
            wsInfo.destroy();
            wsEndpointUrls.remove((Object)wsInfo.getStreamUrl(), (Object)wsEndpointUrl);
            this.assignedNumberIds.remove((Object)wsInfo.getStreamUrl(), (Object)this.getNumberId(wsInfo));
            return true;
        }
        return false;
    }

    private int getNumberId(WsInfo wsInfo) {
        String wsEndpointUrl = wsInfo.getWsEndpointUrl();
        int beginNumberIdIndex = 0;
        int endNumberIdIndex = wsEndpointUrl.lastIndexOf("_");
        if (wsInfo instanceof WsnServiceInfo) {
            beginNumberIdIndex = wsEndpointUrl.lastIndexOf(WSN_SERVICE_ID) + WSN_SERVICE_ID.length();
        } else if (wsInfo instanceof WsProxyInfo) {
            beginNumberIdIndex = wsEndpointUrl.lastIndexOf(WS_PROXY_ID) + WS_PROXY_ID.length();
        } else {
            throw new IllegalStateException("Unknow web service information type: " + wsInfo.getClass());
        }
        return Integer.parseInt(wsEndpointUrl.substring(beginNumberIdIndex, endNumberIdIndex));
    }

    public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage getCurrentMessageRequest) {
        throw new UnsupportedOperationException();
    }

    public SubscribeResponse subscribe(Subscribe subscribe) {
        SubscriptionId subscriptionId = new SubscriptionId();
        String consumerReference = WsnHelper.getAddress((W3CEndpointReference)subscribe.getConsumerReference());
        QName topic = WsnHelper.getTopic((Subscribe)subscribe);
        if ((topic.getNamespaceURI() + topic.getLocalPart()).equals(RAW_REPORT_TOPIC)) {
            Set ids = this.registry.listEventClouds();
            for (EventCloudId id : ids) {
                for (SubscribeProxy proxy : this.registry.getSubscribeProxies(id)) {
                    ProxyMonitoringManager proxyMonitoringManagerInterface = this.getProxyMonitoringManagerInterface(proxy);
                    if (proxyMonitoringManagerInterface == null) continue;
                    proxyMonitoringManagerInterface.enableInputOutputMonitoring(subscriptionId, consumerReference);
                }
            }
        }
        return WsnHelper.createSubscribeResponse((SubscriptionId)subscriptionId, (String)consumerReference);
    }

    public RenewResponse renew(Renew renewRequest) {
        throw new UnsupportedOperationException();
    }

    public UnsubscribeResponse unsubscribe(Unsubscribe unsubscribeRequest) {
        SubscriptionId subscriptionId = WsnHelper.getSubcriptionId((Unsubscribe)unsubscribeRequest);
        Set ids = this.registry.listEventClouds();
        for (EventCloudId id : ids) {
            for (SubscribeProxy proxy : this.registry.getSubscribeProxies(id)) {
                ProxyMonitoringManager proxyMonitoringManagerInterface = this.getProxyMonitoringManagerInterface(proxy);
                if (proxyMonitoringManagerInterface == null) continue;
                proxyMonitoringManagerInterface.disableInputOutputMonitoring(subscriptionId);
            }
        }
        return new UnsubscribeResponse();
    }

    private ProxyMonitoringManager getProxyMonitoringManagerInterface(Object proxyStub) {
        try {
            Component proxy = ((PAInterface)proxyStub).getFcItfOwner();
            PAMembraneController membraneController = Utils.getPAMembraneController((Component)proxy);
            Component proxyMonitoringManager = membraneController.nfGetFcSubComponent("ProxyMonitoringManager");
            if (proxyMonitoringManager == null) {
                return this.addProxyMonitoringManager(proxy, membraneController);
            }
            return (ProxyMonitoringManager)proxyMonitoringManager.getFcInterface("monitoring-services");
        }
        catch (NoSuchInterfaceException nsie) {
            nsie.printStackTrace();
        }
        catch (NoSuchComponentException nsce) {
            nsce.printStackTrace();
        }
        catch (IllegalContentException ice) {
            ice.printStackTrace();
        }
        catch (IllegalLifeCycleException ilce) {
            ilce.printStackTrace();
        }
        catch (IllegalBindingException ibe) {
            ibe.printStackTrace();
        }
        return null;
    }

    private ProxyMonitoringManager addProxyMonitoringManager(Component proxy, PAMembraneController membraneController) throws NoSuchInterfaceException, IllegalLifeCycleException, IllegalContentException, IllegalBindingException, NoSuchComponentException {
        ProxyMonitoringManager stub = ProxyMonitoringManagerFactory.newProxyMonitoringManager();
        Component proxyMonitoringManager = ((PAInterface)stub).getFcItfOwner();
        GCM.getNameController((Component)proxyMonitoringManager).setFcName("ProxyMonitoringManager");
        Utils.getPAGCMLifeCycleController((Component)proxy).stopFc();
        membraneController.stopMembrane();
        membraneController.nfAddFcSubComponent(proxyMonitoringManager);
        membraneController.nfBindFc("monitoring-services-controller", "ProxyMonitoringManager.monitoring-services");
        membraneController.startMembrane();
        Utils.getPAGCMLifeCycleController((Component)proxy).startFc();
        return stub;
    }
}

