/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.utils;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.UUID;
import javax.xml.bind.DatatypeConverter;

public class UniqueId
implements Serializable {
    private static final long serialVersionUID = 130L;
    protected final UUID value;

    public UniqueId() {
        this(UUID.randomUUID());
    }

    protected UniqueId(UUID value) {
        this.value = value;
    }

    public static final UniqueId parseUniqueId(String uniqueId) {
        return new UniqueId(UniqueId.decode(uniqueId));
    }

    public boolean equals(Object obj) {
        return obj instanceof UniqueId && this.value.equals(((UniqueId)obj).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return UniqueId.encode(this.value);
    }

    public static String encode(UUID uuid) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        return DatatypeConverter.printHexBinary((byte[])buffer.array());
    }

    public static UUID decode(String uuid) {
        ByteBuffer buffer = ByteBuffer.wrap(DatatypeConverter.parseHexBinary((String)uuid));
        return new UUID(buffer.getLong(), buffer.getLong());
    }
}

