/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.utils;

import com.hp.hpl.jena.query.BIOInput;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingInputStream;
import com.hp.hpl.jena.sparql.engine.binding.BindingOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class SparqlResultSerializer {
    private SparqlResultSerializer() {
    }

    public static void serialize(OutputStream out, Binding binding) {
        SparqlResultSerializer.serialize(out, binding, false);
    }

    public static void serialize(OutputStream out, Binding binding, boolean gzipped) {
        if (gzipped) {
            try {
                out = new GZIPOutputStream(out);
                if (binding == null) {
                    out.write(0);
                } else {
                    out.write(7);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        BindingOutputStream bos = new BindingOutputStream(out);
        if (binding != null) {
            bos.write(binding);
            bos.flush();
        }
        if (gzipped) {
            try {
                ((GZIPOutputStream)out).finish();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void serialize(OutputStream out, ResultSet resultSet) {
        SparqlResultSerializer.serialize(out, resultSet, false);
    }

    public static void serialize(OutputStream out, ResultSet resultSet, boolean gzipped) {
        if (gzipped) {
            try {
                out = new GZIPOutputStream(out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ResultSetFormatter.outputAsBIO((OutputStream)out, (ResultSet)resultSet);
        if (gzipped) {
            try {
                ((GZIPOutputStream)out).finish();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void serialize(OutputStream out, Model model) {
        SparqlResultSerializer.serialize(out, model, false);
    }

    public static void serialize(OutputStream out, Model model, boolean gzipped) {
        if (gzipped) {
            try {
                out = new GZIPOutputStream(out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        model.write(out, "TURTLE", null);
        if (gzipped) {
            try {
                ((GZIPOutputStream)out).finish();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static Binding deserializeBinding(InputStream in) {
        return SparqlResultSerializer.deserializeBinding(in, false);
    }

    public static Binding deserializeBinding(InputStream in, boolean gzipped) {
        if (gzipped) {
            try {
                in = new GZIPInputStream(in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (gzipped ? ((GZIPInputStream)in).read() == 0 : in.available() == 0) {
                return null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BindingInputStream bis = new BindingInputStream(in);
        return bis.next();
    }

    public static Model deserializeModel(InputStream in) {
        return SparqlResultSerializer.deserializeModel(in, false);
    }

    public static Model deserializeModel(InputStream in, boolean gzipped) {
        Model model = ModelFactory.createDefaultModel();
        if (gzipped) {
            try {
                in = new GZIPInputStream(in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        model.read(in, null, "TURTLE");
        return model;
    }

    public static ResultSet deserializeResultSet(InputStream in) {
        return SparqlResultSerializer.deserializeResultSet(in, false);
    }

    public static ResultSet deserializeResultSet(InputStream in, boolean gzipped) {
        if (gzipped) {
            try {
                in = new GZIPInputStream(in);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ResultSet resultSet = BIOInput.fromBIO((InputStream)in);
        return resultSet;
    }
}

