/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.reasoner;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import fr.inria.eventcloud.api.exceptions.MalformedSparqlQueryException;
import fr.inria.eventcloud.exceptions.DecompositionException;
import fr.inria.eventcloud.messages.request.can.SparqlAtomicRequest;
import fr.inria.eventcloud.reasoner.AtomicQuery;
import fr.inria.eventcloud.reasoner.SparqlDecomposer;
import fr.inria.eventcloud.reasoner.SparqlDecompositionResult;
import java.util.List;

public class SparqlReasoner {
    private SparqlReasoner() {
    }

    public static List<SparqlAtomicRequest> parse(String sparqlQuery) throws MalformedSparqlQueryException {
        try {
            SparqlDecompositionResult sparqlDecompositionResult = SparqlDecomposer.getInstance().decompose(sparqlQuery);
            List<AtomicQuery> atomicQueries = sparqlDecompositionResult.getAtomicQueries();
            ImmutableList sparqlAtomicRequests = FluentIterable.from(atomicQueries).transform((Function)new Function<AtomicQuery, SparqlAtomicRequest>(){

                public SparqlAtomicRequest apply(AtomicQuery input) {
                    return new SparqlAtomicRequest(input);
                }
            }).toImmutableList();
            return sparqlAtomicRequests;
        }
        catch (DecompositionException e) {
            throw new MalformedSparqlQueryException(sparqlQuery, (Throwable)e);
        }
    }
}

