/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.reasoner;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.OpWalker;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.ExprVisitor;
import com.hp.hpl.jena.sparql.expr.ExprVisitorBase;
import com.hp.hpl.jena.sparql.expr.ExprWalker;
import com.hp.hpl.jena.sparql.function.FunctionRegistry;
import fr.inria.eventcloud.exceptions.DecompositionException;
import fr.inria.eventcloud.reasoner.AtomicQuery;
import fr.inria.eventcloud.reasoner.RemoveMetadataFunction;
import fr.inria.eventcloud.reasoner.SparqlDecompositionResult;
import java.util.ArrayList;
import java.util.List;

public final class SparqlDecomposer {
    private static final String FUNCTION_META_GRAPH_IRI = "http://eventcloud.inria.fr/function#removeMetadata";

    private SparqlDecomposer() {
        FunctionRegistry.get().put(FUNCTION_META_GRAPH_IRI, RemoveMetadataFunction.class);
    }

    public SparqlDecompositionResult decompose(String sparqlQuery) throws DecompositionException {
        Query query = QueryFactory.create((String)sparqlQuery);
        Op op = Algebra.compile((Query)query);
        CustomOpVisitor visitor = new CustomOpVisitor();
        OpWalker.walk((Op)op, (OpVisitor)visitor);
        if (visitor.nbGraphPatterns == 1) {
            return new SparqlDecompositionResult(this.createAtomicQueries(query, visitor));
        }
        if (visitor.nbGraphPatterns == 0) {
            throw new DecompositionException("The specified SPARQL query does not contain any graph pattern: " + sparqlQuery);
        }
        throw new DecompositionException("Multiple graph patterns are not yet supported");
    }

    private List<AtomicQuery> createAtomicQueries(Query query, CustomOpVisitor visitor) {
        ArrayList<AtomicQuery> result = new ArrayList<AtomicQuery>(visitor.basicGraphPatterns.size());
        for (OpBGP bgp : visitor.basicGraphPatterns) {
            BasicPattern bp = bgp.getPattern();
            for (int i = 0; i < bp.size(); ++i) {
                Triple triple = bp.get(i);
                AtomicQuery atomicQuery = this.createAtomicQuery(query, visitor, triple);
                result.add(atomicQuery);
            }
        }
        return result;
    }

    private AtomicQuery createAtomicQuery(Query query, CustomOpVisitor visitor, Triple triple) {
        AtomicQuery atomicQuery = new AtomicQuery(visitor.graphNode, triple.getSubject(), triple.getPredicate(), triple.getObject());
        if (query.isDistinct()) {
            atomicQuery.setDistinct(true);
        }
        if (query.isReduced()) {
            atomicQuery.setReduced(true);
        }
        if (visitor.basicGraphPatterns.size() == 1 && query.hasLimit()) {
            atomicQuery.setLimit(query.getLimit());
        }
        if (query.hasLimit() && query.getOrderBy() != null) {
            atomicQuery.setOrderBy(this.filterSortConditions(atomicQuery, query.getOrderBy()));
        }
        return atomicQuery;
    }

    private List<SortCondition> filterSortConditions(AtomicQuery atomicQuery, List<SortCondition> sortConditions) {
        SortConditionVisitor sortConditionVisitor = new SortConditionVisitor();
        ArrayList<SortCondition> result = new ArrayList<SortCondition>(sortConditions.size());
        for (SortCondition sortCondition : sortConditions) {
            ExprWalker.walk((ExprVisitor)sortConditionVisitor, (Expr)sortCondition.getExpression());
            if (!atomicQuery.containsVariable(sortConditionVisitor.var.getVarName())) continue;
            result.add(sortCondition);
        }
        return result;
    }

    public static SparqlDecomposer getInstance() {
        return Singleton.INSTANCE;
    }

    private static class CustomOpVisitor
    extends OpVisitorBase {
        private Node graphNode;
        private List<OpBGP> basicGraphPatterns = new ArrayList<OpBGP>();
        private int nbGraphPatterns;
        private List<ExprList> filterConstraints = new ArrayList<ExprList>();

        public void visit(OpGraph opGraph) {
            super.visit(opGraph);
            if (this.graphNode == null) {
                this.graphNode = opGraph.getNode();
            }
            ++this.nbGraphPatterns;
        }

        public void visit(OpBGP opBGP) {
            super.visit(opBGP);
            this.basicGraphPatterns.add(opBGP);
        }

        public void visit(OpFilter opFilter) {
            super.visit(opFilter);
            this.filterConstraints.add(opFilter.getExprs());
        }
    }

    private static class SortConditionVisitor
    extends ExprVisitorBase {
        private ExprVar var;

        private SortConditionVisitor() {
        }

        public void visit(ExprVar var) {
            super.visit(var);
            this.var = var;
        }
    }

    private static class Singleton {
        private static final SparqlDecomposer INSTANCE = new SparqlDecomposer();

        private Singleton() {
        }
    }
}

