/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.reasoner;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.api.wrappers.ResultSetWrapper;
import fr.inria.eventcloud.datastore.AccessMode;
import fr.inria.eventcloud.datastore.TransactionalDatasetGraph;
import fr.inria.eventcloud.datastore.TransactionalTdbDatastore;
import fr.inria.eventcloud.messages.response.can.QuadruplePatternResponse;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;

public class SparqlColander
implements Closeable {
    private TransactionalTdbDatastore datastore;

    public SparqlColander(TransactionalTdbDatastore datastore) {
        this.datastore = datastore;
        this.datastore.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean filterSparqlAsk(String sparqlAskQuery, List<QuadruplePatternResponse> quadruplePatternResponses) {
        this.cleanAndFill(this.datastore, quadruplePatternResponses);
        boolean result = false;
        TransactionalDatasetGraph txnGraph = this.datastore.begin(AccessMode.READ_ONLY);
        QueryExecution qExec = null;
        try {
            qExec = QueryExecutionFactory.create((String)sparqlAskQuery, (Dataset)txnGraph.getUnderlyingDataset());
            result = qExec.execAsk();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (qExec != null) {
                qExec.close();
            }
            txnGraph.end();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Model filterSparqlConstruct(String sparqlConstructQuery, List<QuadruplePatternResponse> quadruplePatternResponses) {
        this.cleanAndFill(this.datastore, quadruplePatternResponses);
        Model result = null;
        TransactionalDatasetGraph txnGraph = this.datastore.begin(AccessMode.READ_ONLY);
        QueryExecution qExec = null;
        try {
            qExec = QueryExecutionFactory.create((String)sparqlConstructQuery, (Dataset)txnGraph.getUnderlyingDataset());
            result = qExec.execConstruct();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (qExec != null) {
                qExec.close();
            }
            txnGraph.end();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet filterSparqlSelect(String sparqlSelectQuery, List<QuadruplePatternResponse> quadruplePatternResponses) {
        this.cleanAndFill(this.datastore, quadruplePatternResponses);
        ResultSetWrapper result = null;
        TransactionalDatasetGraph txnGraph = this.datastore.begin(AccessMode.READ_ONLY);
        QueryExecution qExec = null;
        try {
            qExec = QueryExecutionFactory.create((String)sparqlSelectQuery, (Dataset)txnGraph.getUnderlyingDataset());
            result = new ResultSetWrapper(qExec.execSelect());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (qExec != null) {
                qExec.close();
            }
            txnGraph.end();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAndFill(TransactionalTdbDatastore datastore, List<QuadruplePatternResponse> quadruplePatternResponses) {
        TransactionalDatasetGraph txnGraph = datastore.begin(AccessMode.WRITE);
        try {
            txnGraph.delete(Node.ANY, Node.ANY, Node.ANY, Node.ANY);
            for (QuadruplePatternResponse qpResponse : quadruplePatternResponses) {
                for (Quadruple quad : (List)qpResponse.getResult()) {
                    Node graph = quad.createMetaGraphNode();
                    txnGraph.add(graph, quad.getSubject(), quad.getPredicate(), quad.getObject());
                }
            }
            txnGraph.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            txnGraph.end();
        }
    }

    @Override
    public void close() throws IOException {
        this.datastore.close();
    }
}

