/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.reasoner;

import com.google.common.base.Function;
import com.google.common.collect.BiMap;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpAsQuery;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;
import fr.inria.eventcloud.api.QuadruplePattern;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openjena.riot.out.OutputLangUtils;
import org.openjena.riot.tokens.Token;
import org.openjena.riot.tokens.TokenType;
import org.openjena.riot.tokens.Tokenizer;
import org.openjena.riot.tokens.TokenizerFactory;

public final class AtomicQuery
implements Serializable {
    private static final long serialVersionUID = 130L;
    private transient Node[] nodes;
    private transient BiMap<String, Integer> vars;
    private transient Op opRepresentation;
    private boolean distinct = false;
    private boolean reduced = false;
    private long limit = Long.MIN_VALUE;
    private transient List<SortCondition> orderBy;

    public AtomicQuery(Node graph, Node subject, Node predicate, Node object) {
        this.nodes = new Node[]{graph, subject, predicate, object};
    }

    public boolean hasLiteralObject() {
        return this.nodes[2] != null && this.nodes[2].isLiteral();
    }

    public String getVarName(int index) {
        return (String)this.getVarDetails().inverse().get((Object)index);
    }

    public int getVarIndex(String varName) {
        Integer result = (Integer)this.getVarDetails().get((Object)varName);
        if (result == null) {
            return -1;
        }
        return result;
    }

    public boolean containsVariable(String varName) {
        return this.getVarDetails().containsKey((Object)varName);
    }

    public synchronized Op getOpRepresentation() {
        if (this.opRepresentation == null) {
            BasicPattern bp = new BasicPattern();
            bp.add(Triple.create((Node)this.filterAndTransformNodeVariableToVar(this.getSubject()), (Node)this.filterAndTransformNodeVariableToVar(this.getPredicate()), (Node)this.filterAndTransformNodeVariableToVar(this.getObject())));
            OpGraph op = new OpGraph(this.filterAndTransformNodeVariableToVar(this.getGraph()), (Op)new OpBGP(bp));
            if (this.orderBy != null) {
                op = new OpOrder((Op)op, this.orderBy);
            }
            op = new OpProject((Op)op, (List)ImmutableList.copyOf(this.getVars()));
            if (this.distinct) {
                op = new OpDistinct((Op)op);
            }
            if (this.reduced) {
                op = OpReduced.create((Op)op);
            }
            if (this.hasLimit()) {
                op = new OpSlice((Op)op, Long.MIN_VALUE, this.limit);
            }
            this.opRepresentation = op;
        }
        return this.opRepresentation;
    }

    public Node filterAndTransformNodeVariableToVar(Node node) {
        if (node.isVariable()) {
            return Var.alloc((Node)node);
        }
        return node;
    }

    private synchronized BiMap<String, Integer> getVarDetails() {
        if (this.vars == null) {
            ImmutableBiMap.Builder bimapBuilder = ImmutableBiMap.builder();
            for (int i = 0; i < this.nodes.length; ++i) {
                if (!this.nodes[i].isVariable()) continue;
                bimapBuilder.put((Object)this.nodes[i].getName(), (Object)i);
            }
            this.vars = bimapBuilder.build();
        }
        return this.vars;
    }

    private static final Node replaceVarNodeByNodeAny(Node node) {
        if (node.isVariable()) {
            return Node.ANY;
        }
        return node;
    }

    public QuadruplePattern getQuadruplePattern() {
        return new QuadruplePattern(AtomicQuery.replaceVarNodeByNodeAny(this.nodes[0]), AtomicQuery.replaceVarNodeByNodeAny(this.nodes[1]), AtomicQuery.replaceVarNodeByNodeAny(this.nodes[2]), AtomicQuery.replaceVarNodeByNodeAny(this.nodes[3]));
    }

    public Node getGraph() {
        return this.nodes[0];
    }

    public Node getSubject() {
        return this.nodes[1];
    }

    public Node getPredicate() {
        return this.nodes[2];
    }

    public Node getObject() {
        return this.nodes[3];
    }

    public Node[] toArray() {
        return (Node[])this.nodes.clone();
    }

    public List<Var> getVars() {
        return FluentIterable.from((Iterable)this.getVarDetails().keySet()).transform((Function)new Function<String, Var>(){

            public Var apply(String varName) {
                return Var.alloc((String)varName);
            }
        }).toImmutableList();
    }

    public int getNbVars() {
        return this.getVarDetails().size();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean isReduced() {
        return this.reduced;
    }

    public long getLimit() {
        return this.limit;
    }

    public List<SortCondition> getOrderBy() {
        return this.orderBy;
    }

    public boolean hasLimit() {
        return this.limit >= 0L;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setReduced(boolean reduced) {
        this.reduced = reduced;
    }

    public void setLimit(long limit) {
        this.limit = limit;
    }

    public void setOrderBy(List<SortCondition> sortConditions) {
        this.orderBy = sortConditions;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.distinct ? 1231 : 1237);
        result = 31 * result + (int)(this.limit ^ this.limit >>> 32);
        result = 31 * result + Arrays.hashCode(this.nodes);
        result = 31 * result + (this.orderBy == null ? 0 : this.orderBy.hashCode());
        result = 31 * result + (this.reduced ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AtomicQuery other = (AtomicQuery)obj;
        if (this.distinct != other.distinct) {
            return false;
        }
        if (this.limit != other.limit) {
            return false;
        }
        if (!Arrays.equals(this.nodes, other.nodes)) {
            return false;
        }
        if (this.orderBy == null ? other.orderBy != null : !this.orderBy.equals(other.orderBy)) {
            return false;
        }
        return this.reduced == other.reduced;
    }

    public String toString() {
        return OpAsQuery.asQuery((Op)this.getOpRepresentation()).toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int nbSortConditions = in.readInt();
        if (nbSortConditions > 0) {
            this.orderBy = new ArrayList<SortCondition>(nbSortConditions);
            for (int i = 0; i < nbSortConditions; ++i) {
                int direction = in.readInt();
                Expr expr = ExprUtils.parse((String)in.readUTF());
                this.orderBy.add(new SortCondition(expr, direction));
            }
        }
        this.nodes = new Node[4];
        Tokenizer tokenizer = TokenizerFactory.makeTokenizerUTF8((InputStream)in);
        for (int i = 0; i < this.nodes.length; ++i) {
            Token token = tokenizer.next();
            Node node = token.getType() == TokenType.VAR ? Node.createVariable((String)token.getImage()) : token.asNode();
            this.nodes[i] = node;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        if (this.orderBy != null) {
            out.writeInt(this.orderBy.size());
            for (SortCondition sortCondition : this.orderBy) {
                out.writeInt(sortCondition.getDirection());
                out.writeUTF(WriterExpr.asString((Expr)sortCondition.getExpression()));
            }
        } else {
            out.writeInt(0);
        }
        OutputStreamWriter outWriter = new OutputStreamWriter(out);
        for (int i = 0; i < this.nodes.length; ++i) {
            OutputLangUtils.output((Writer)outWriter, (Node)this.nodes[i], null);
            if (i >= this.nodes.length - 1) continue;
            outWriter.write(32);
        }
        outWriter.flush();
    }
}

