/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.pubsub.solutions;

import fr.inria.eventcloud.api.PublishSubscribeConstants;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.pubsub.solutions.Solution;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class QuadruplesSolution
extends Solution<Collection<Quadruple>> {
    private int nbQuadruplesExpected;
    private int nbQuadruplesReceived;

    public QuadruplesSolution(List<Quadruple> chunk) {
        super(new HashSet(chunk.size(), 0.9f));
        this.add(chunk);
    }

    @Override
    public synchronized void merge(Collection<Quadruple> chunk) {
        this.add(chunk);
    }

    private void add(Collection<Quadruple> chunk) {
        for (Quadruple quadruple : chunk) {
            if (this.nbQuadruplesExpected == 0 && quadruple.getPredicate().equals((Object)PublishSubscribeConstants.EVENT_NB_QUADRUPLES_NODE)) {
                this.nbQuadruplesExpected = (Integer)quadruple.getObject().getLiteralValue();
                continue;
            }
            ((Collection)this.chunks).add(quadruple);
            ++this.nbQuadruplesReceived;
        }
    }

    @Override
    public boolean isReady() {
        return this.nbQuadruplesReceived == this.nbQuadruplesExpected;
    }
}

