/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.pubsub.notifications;

import com.google.common.base.Objects;
import com.hp.hpl.jena.graph.Node;
import fr.inria.eventcloud.api.SubscriptionId;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public class NotificationId
implements Serializable {
    private static final long serialVersionUID = 130L;
    protected final SubscriptionId subscriptionId;
    protected final String eventId;

    public NotificationId(SubscriptionId subscriptionId, Node eventId) {
        this(subscriptionId, eventId.getURI());
    }

    protected NotificationId(SubscriptionId subscriptionId, String eventId) {
        this.subscriptionId = subscriptionId;
        this.eventId = eventId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.subscriptionId, this.eventId});
    }

    public boolean equals(Object that) {
        if (that instanceof NotificationId) {
            NotificationId other = (NotificationId)that;
            return this.subscriptionId.equals((Object)other.subscriptionId) && this.eventId.equals(other.eventId);
        }
        return false;
    }

    public String toString() {
        return this.eventId + this.subscriptionId.toString();
    }

    public static final class Serializer
    implements org.mapdb.Serializer<NotificationId>,
    Serializable {
        private static final long serialVersionUID = 1L;

        public void serialize(DataOutput out, NotificationId notificationId) throws IOException {
            out.writeUTF(notificationId.eventId);
            SubscriptionId.SERIALIZER.serialize(out, notificationId.subscriptionId);
        }

        public NotificationId deserialize(DataInput in, int available) throws IOException {
            String eventId = in.readUTF();
            SubscriptionId subscriptionId = SubscriptionId.SERIALIZER.deserialize(in, available);
            return new NotificationId(subscriptionId, eventId);
        }
    }
}

