/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.pubsub.notifications;

import com.hp.hpl.jena.graph.Node;
import fr.inria.eventcloud.api.SubscriptionId;
import fr.inria.eventcloud.pubsub.notifications.NotificationId;
import java.io.Serializable;

public abstract class Notification<T>
implements Serializable {
    private static final long serialVersionUID = 130L;
    private final NotificationId id;
    private final T content;
    private final String source;

    public Notification(SubscriptionId subscriptionId, Node eventId, String source, T binding) {
        this(subscriptionId, eventId.getURI(), source, binding);
    }

    public Notification(SubscriptionId subscriptionId, String eventId, String source, T binding) {
        this(new NotificationId(subscriptionId, eventId), subscriptionId, source, binding);
    }

    public Notification(NotificationId id, SubscriptionId subscriptionId, String source, T binding) {
        this.id = id;
        this.content = binding;
        this.source = source;
    }

    public NotificationId getId() {
        return this.id;
    }

    public SubscriptionId getSubscriptionId() {
        return this.id.subscriptionId;
    }

    public T getContent() {
        return this.content;
    }

    public String getMetaEventId() {
        return this.id.eventId;
    }

    public String getSource() {
        return this.source;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Notification && this.id.equals(((Notification)obj).id);
    }

    public String toString() {
        return this.id.toString();
    }
}

