/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.pubsub;

import com.google.common.collect.ImmutableList;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import fr.inria.eventcloud.api.PublishSubscribeConstants;
import fr.inria.eventcloud.api.Quadruplable;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.api.SubscriptionId;
import fr.inria.eventcloud.datastore.AccessMode;
import fr.inria.eventcloud.datastore.QuadrupleIterator;
import fr.inria.eventcloud.datastore.TransactionalDatasetGraph;
import fr.inria.eventcloud.datastore.TransactionalTdbDatastore;
import fr.inria.eventcloud.datastore.VariableDatatype;
import fr.inria.eventcloud.pubsub.PublishSubscribeUtils;
import fr.inria.eventcloud.reasoner.AtomicQuery;
import java.util.HashMap;
import java.util.List;

public class Subsubscription
implements Quadruplable {
    private final SubscriptionId originalId;
    private final SubscriptionId parentId;
    private final SubscriptionId id;
    private final int index;
    private final AtomicQuery atomicQuery;

    public Subsubscription(SubscriptionId originalId, SubscriptionId parentId, AtomicQuery atomicQuery, int index) {
        this.originalId = originalId;
        this.parentId = parentId;
        this.atomicQuery = atomicQuery;
        this.index = index;
        this.id = new SubscriptionId();
    }

    private Subsubscription(SubscriptionId originalId, SubscriptionId parentId, SubscriptionId id, int index, Node graph, Node subject, Node predicate, Node object) {
        this.originalId = originalId;
        this.parentId = parentId;
        this.id = id;
        this.index = index;
        this.atomicQuery = new AtomicQuery(graph, subject, predicate, object);
    }

    public SubscriptionId getOriginalId() {
        return this.originalId;
    }

    public SubscriptionId getParentId() {
        return this.parentId;
    }

    public SubscriptionId getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public AtomicQuery getAtomicQuery() {
        return this.atomicQuery;
    }

    public List<Quadruple> toQuadruples() {
        ImmutableList.Builder result = new ImmutableList.Builder();
        Node originalSubscriptionURI = PublishSubscribeUtils.createSubscriptionIdUri(this.originalId);
        Node subSubscriptionURI = Node.createURI((String)("urn:ec:ss:" + this.id.toString()));
        result.add((Object)new Quadruple(originalSubscriptionURI, subSubscriptionURI, PublishSubscribeConstants.SUBSUBSCRIPTION_ID_NODE, Node.createLiteral((String)this.id.toString()), false, false));
        result.add((Object)new Quadruple(originalSubscriptionURI, subSubscriptionURI, PublishSubscribeConstants.SUBSUBSCRIPTION_INDEX_NODE, Node.createLiteral((String)Integer.toString(this.index), (RDFDatatype)XSDDatatype.XSDint), false, false));
        result.add((Object)new Quadruple(originalSubscriptionURI, subSubscriptionURI, PublishSubscribeConstants.SUBSUBSCRIPTION_GRAPH_VALUE_NODE, Subsubscription.replaceVarNodeByVariableTypedLiteral(this.atomicQuery.getGraph()), false, false));
        result.add((Object)new Quadruple(originalSubscriptionURI, subSubscriptionURI, PublishSubscribeConstants.SUBSUBSCRIPTION_SUBJECT_VALUE_NODE, Subsubscription.replaceVarNodeByVariableTypedLiteral(this.atomicQuery.getSubject()), false, false));
        result.add((Object)new Quadruple(originalSubscriptionURI, subSubscriptionURI, PublishSubscribeConstants.SUBSUBSCRIPTION_PREDICATE_VALUE_NODE, Subsubscription.replaceVarNodeByVariableTypedLiteral(this.atomicQuery.getPredicate()), false, false));
        result.add((Object)new Quadruple(originalSubscriptionURI, subSubscriptionURI, PublishSubscribeConstants.SUBSUBSCRIPTION_OBJECT_VALUE_NODE, Subsubscription.replaceVarNodeByVariableTypedLiteral(this.atomicQuery.getObject()), false, false));
        return result.build();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Subsubscription && this.id.equals((Object)((Subsubscription)obj).id);
    }

    public String toString() {
        return "Subsubscription [parentId=" + this.parentId + ", id=" + this.id + ", index=" + this.index + ", atomicQuery=" + this.atomicQuery + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Subsubscription parseFrom(TransactionalTdbDatastore datastore, SubscriptionId subscriptionId, Node subSubscriptionIdNode) {
        TransactionalDatasetGraph txnGraph = datastore.begin(AccessMode.READ_ONLY);
        try {
            Subsubscription subsubscription = Subsubscription.parseFrom(txnGraph, subscriptionId, subSubscriptionIdNode);
            return subsubscription;
        }
        finally {
            txnGraph.end();
        }
    }

    public static final Subsubscription parseFrom(TransactionalDatasetGraph txnGraph, SubscriptionId subscriptionId, Node subSubscriptionIdNode) {
        HashMap<String, Node> properties = new HashMap<String, Node>();
        SubscriptionId originalId = null;
        QuadrupleIterator it = txnGraph.find(Node.ANY, subSubscriptionIdNode, Node.ANY, Node.ANY);
        while (it.hasNext()) {
            Quadruple quad = it.next();
            properties.put(quad.getPredicate().toString(), quad.getObject());
            if (it.hasNext()) continue;
            originalId = PublishSubscribeUtils.extractSubscriptionId(quad.getGraph());
        }
        return new Subsubscription(originalId, subscriptionId, SubscriptionId.parseSubscriptionId((String)PublishSubscribeUtils.extractSubscriptionId(subSubscriptionIdNode.getURI())), (Integer)((Node)properties.get("urn:ec:ss:index")).getLiteralValue(), Subsubscription.replaceVariableTypedLiteralByVarNode((Node)properties.get("urn:ec:ss:g")), Subsubscription.replaceVariableTypedLiteralByVarNode((Node)properties.get("urn:ec:ss:s")), Subsubscription.replaceVariableTypedLiteralByVarNode((Node)properties.get("urn:ec:ss:p")), Subsubscription.replaceVariableTypedLiteralByVarNode((Node)properties.get("urn:ec:ss:o")));
    }

    private static final Node replaceVarNodeByVariableTypedLiteral(Node node) {
        if (node.isVariable()) {
            return Node.createLiteral((String)node.getName(), (RDFDatatype)VariableDatatype.getInstance());
        }
        return node;
    }

    private static final Node replaceVariableTypedLiteralByVarNode(Node node) {
        if (node.isLiteral() && node.getLiteralDatatype() != null && node.getLiteralDatatype().equals(VariableDatatype.getInstance())) {
            return (Node)node.getLiteralValue();
        }
        return node;
    }
}

