/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.pubsub;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpAsQuery;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.Transformer;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.api.SubscriptionId;
import fr.inria.eventcloud.pubsub.Subscription;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class SubscriptionRewriter {
    private SubscriptionRewriter() {
    }

    public static final Subscription rewrite(Subscription subscription, Quadruple quad) {
        return SubscriptionRewriter.removeFirstTriplePatternAndReplaceVars(subscription, SubscriptionRewriter.createBGPTransformCopy(quad));
    }

    public static final Subscription rewrite(Subscription subscription, Binding binding) {
        return SubscriptionRewriter.removeFirstTriplePatternAndReplaceVars(subscription, SubscriptionRewriter.createBGPTransformCopy(binding));
    }

    private static final Subscription removeFirstTriplePatternAndReplaceVars(Subscription subscription, TransformCopy tc) {
        return new Subscription(subscription.getOriginalId(), subscription.getId(), new SubscriptionId(), subscription.getCreationTime(), subscription.getIndexationTime(), OpAsQuery.asQuery((Op)Transformer.transform((Transform)tc, (Op)Algebra.compile((Query)QueryFactory.create((String)subscription.getSparqlQuery())))).toString(), subscription.getSubscriberUrl(), subscription.getSubscriptionDestination(), subscription.getType());
    }

    private static final TransformCopy createBGPTransformCopy(final Quadruple quad) {
        final HashMap vars = new HashMap(3);
        return new TransformCopy(){

            public Op transform(OpBGP opBGP) {
                BasicPattern oldBasicPattern = opBGP.getPattern();
                BasicPattern newBasicPattern = new BasicPattern();
                Iterator it = oldBasicPattern.iterator();
                if (!it.hasNext()) {
                    throw new IllegalArgumentException("The SPARQL query to rewrite must have at least 2 triple patterns");
                }
                Triple triple = (Triple)it.next();
                if (triple.getSubject().isVariable()) {
                    vars.put(triple.getSubject(), quad.getSubject());
                }
                if (triple.getPredicate().isVariable()) {
                    vars.put(triple.getPredicate(), quad.getPredicate());
                }
                if (triple.getObject().isVariable()) {
                    vars.put(triple.getObject(), quad.getObject());
                }
                if (!it.hasNext()) {
                    throw new IllegalArgumentException("The SPARQL query to rewrite must have at least 2 triple patterns");
                }
                while (it.hasNext()) {
                    triple = (Triple)it.next();
                    newBasicPattern.add(Triple.create((Node)SubscriptionRewriter.replaceVarByQuadrupleValue(triple.getSubject(), vars, quad.getSubject()), (Node)SubscriptionRewriter.replaceVarByQuadrupleValue(triple.getPredicate(), vars, quad.getPredicate()), (Node)SubscriptionRewriter.replaceVarByQuadrupleValue(triple.getObject(), vars, quad.getObject())));
                }
                return new OpBGP(newBasicPattern);
            }

            public Op transform(OpGraph opGraph, Op subOp) {
                if (opGraph.getNode().isVariable()) {
                    return new OpGraph(quad.getGraph(), subOp);
                }
                return new OpGraph(opGraph.getNode(), subOp);
            }
        };
    }

    private static final TransformCopy createBGPTransformCopy(final Binding binding) {
        return new TransformCopy(){

            public Op transform(OpBGP opBGP) {
                BasicPattern oldBasicPattern = opBGP.getPattern();
                BasicPattern newBasicPattern = new BasicPattern();
                Iterator it = oldBasicPattern.iterator();
                if (!it.hasNext()) {
                    throw new IllegalArgumentException("The SPARQL query to rewrite must have at least 2 triple patterns");
                }
                Triple triple = (Triple)it.next();
                if (!it.hasNext()) {
                    throw new IllegalArgumentException("The SPARQL query to rewrite must have at least 2 triple patterns");
                }
                while (it.hasNext()) {
                    triple = (Triple)it.next();
                    newBasicPattern.add(Triple.create((Node)SubscriptionRewriter.replaceVarByBindingValue(triple.getSubject(), binding), (Node)SubscriptionRewriter.replaceVarByBindingValue(triple.getPredicate(), binding), (Node)SubscriptionRewriter.replaceVarByBindingValue(triple.getObject(), binding)));
                }
                return new OpBGP(newBasicPattern);
            }
        };
    }

    private static final Node replaceVarByQuadrupleValue(Node tripleNode, Map<Node, Node> vars, Node quadNode) {
        Node value = vars.get(tripleNode);
        if (value != null) {
            return value;
        }
        return tripleNode;
    }

    private static final Node replaceVarByBindingValue(Node tripleNode, Binding binding) {
        Node value;
        if (tripleNode.isVariable() && (value = binding.get(Var.alloc((String)tripleNode.getName()))) != null) {
            return value;
        }
        return tripleNode;
    }
}

