/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.pubsub;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashCodes;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.sparql.core.Var;
import fr.inria.eventcloud.api.PublishSubscribeConstants;
import fr.inria.eventcloud.api.Quadruplable;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.api.SubscriptionId;
import fr.inria.eventcloud.api.listeners.NotificationListenerType;
import fr.inria.eventcloud.configuration.EventCloudProperties;
import fr.inria.eventcloud.datastore.AccessMode;
import fr.inria.eventcloud.datastore.QuadrupleIterator;
import fr.inria.eventcloud.datastore.TransactionalDatasetGraph;
import fr.inria.eventcloud.datastore.TransactionalTdbDatastore;
import fr.inria.eventcloud.exceptions.DecompositionException;
import fr.inria.eventcloud.factories.ProxyFactory;
import fr.inria.eventcloud.proxies.SubscribeProxy;
import fr.inria.eventcloud.pubsub.PublishSubscribeUtils;
import fr.inria.eventcloud.pubsub.Subsubscription;
import fr.inria.eventcloud.reasoner.AtomicQuery;
import fr.inria.eventcloud.reasoner.SparqlDecomposer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.xml.bind.DatatypeConverter;

public class Subscription
implements Quadruplable,
Serializable {
    private static final long serialVersionUID = 130L;
    public static final LoadingCache<String, SubscribeProxy> SUBSCRIBE_PROXIES_CACHE;
    private final SubscriptionId originalId;
    private final SubscriptionId parentId;
    private final SubscriptionId id;
    private final long creationTime;
    private long indexationTime;
    private final String sparqlQuery;
    private final String subscriberUrl;
    private final String subscriptionDestination;
    private final List<Stub> stubs;
    private final NotificationListenerType type;
    private transient Set<Var> resultVars;
    private transient Subsubscription[] subSubscriptions;
    private transient Node graphNode;

    public Subscription(SubscriptionId originalId, SubscriptionId parentId, SubscriptionId id, long creationTime, String sparqlQuery, String subscriberUrl, String subscriptionDestination, NotificationListenerType listenerType) {
        this(originalId, parentId, id, creationTime, -1L, sparqlQuery, subscriberUrl, subscriptionDestination, listenerType);
    }

    public Subscription(SubscriptionId originalId, SubscriptionId parentId, SubscriptionId id, long creationTime, long indexationTime, String sparqlQuery, String subscriberUrl, String subscriptionDestination, NotificationListenerType listenerType) {
        this.originalId = originalId;
        this.parentId = parentId;
        this.id = id;
        this.creationTime = creationTime;
        this.indexationTime = indexationTime;
        this.sparqlQuery = sparqlQuery;
        this.subscriberUrl = subscriberUrl;
        this.subscriptionDestination = subscriptionDestination;
        this.type = listenerType;
        this.stubs = new ArrayList<Stub>();
    }

    public final void addStub(Stub stub) {
        this.stubs.add(stub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Subscription parseFrom(TransactionalTdbDatastore datastore, SubscriptionId id) {
        TransactionalDatasetGraph txnGraph = datastore.begin(AccessMode.READ_ONLY);
        try {
            Subscription subscription = Subscription.parseFrom(txnGraph, id);
            return subscription;
        }
        finally {
            txnGraph.end();
        }
    }

    public static final Subscription parseFrom(TransactionalDatasetGraph txnGraph, SubscriptionId id) {
        HashMap<String, Node> basicInfo = new HashMap<String, Node>();
        ArrayList<Node> subSubscriptionIds = new ArrayList<Node>();
        ArrayList<String> stubs = new ArrayList<String>();
        QuadrupleIterator it = txnGraph.find(Node.ANY, PublishSubscribeUtils.createSubscriptionIdUri(id), Node.ANY, Node.ANY);
        if (!it.hasNext()) {
            return null;
        }
        while (it.hasNext()) {
            Quadruple quad = it.next();
            if (quad.getPredicate().equals((Object)PublishSubscribeConstants.SUBSCRIPTION_HAS_SUBSUBSCRIPTION_NODE)) {
                subSubscriptionIds.add(quad.getObject());
                continue;
            }
            if (quad.getPredicate().equals((Object)PublishSubscribeConstants.SUBSCRIPTION_STUB_NODE)) {
                stubs.add(quad.getObject().getLiteralLexicalForm());
                continue;
            }
            basicInfo.put(quad.getPredicate().toString(), quad.getObject());
        }
        SubscriptionId parentId = null;
        if (basicInfo.get("urn:ec:s:pid") != null) {
            parentId = SubscriptionId.parseSubscriptionId((String)((Node)basicInfo.get("urn:ec:s:pid")).getLiteralLexicalForm());
        }
        SubscriptionId originalId = null;
        if (basicInfo.get("urn:ec:s:oid") != null) {
            originalId = SubscriptionId.parseSubscriptionId((String)PublishSubscribeUtils.extractSubscriptionId(((Node)basicInfo.get("urn:ec:s:oid")).getURI()));
        }
        String subscriptionDestination = null;
        if (basicInfo.get("urn:ec:event:sdestination") != null) {
            subscriptionDestination = ((Node)basicInfo.get("urn:ec:event:sdestination")).getLiteralLexicalForm();
        }
        Subscription subscription = new Subscription(originalId, parentId, SubscriptionId.parseSubscriptionId((String)((Node)basicInfo.get("urn:ec:s:id")).getLiteralLexicalForm()), DatatypeConverter.parseDateTime((String)((Node)basicInfo.get("urn:ec:s:ctime")).getLiteralLexicalForm()).getTimeInMillis(), DatatypeConverter.parseDateTime((String)((Node)basicInfo.get("urn:ec:s:itime")).getLiteralLexicalForm()).getTimeInMillis(), ((Node)basicInfo.get("urn:ec:s:query")).getLiteralLexicalForm(), ((Node)basicInfo.get("urn:ec:s:subscriber")).getURI(), subscriptionDestination, NotificationListenerType.UNKNOWN.convert(((Integer)((Node)basicInfo.get("urn:ec:s:type")).getLiteralValue()).shortValue()));
        for (String stub : stubs) {
            String[] parsedStub = stub.split(" ");
            subscription.addStub(new Stub(parsedStub[1], Subscription.fromString(parsedStub[0])));
        }
        subscription.subSubscriptions = new Subsubscription[subSubscriptionIds.size()];
        for (Node subSubscriptionIdNode : subSubscriptionIds) {
            Subsubscription s;
            subscription.subSubscriptions[s.getIndex()] = s = Subsubscription.parseFrom(txnGraph, SubscriptionId.parseSubscriptionId((String)((Node)basicInfo.get("urn:ec:s:id")).getLiteralLexicalForm()), subSubscriptionIdNode);
        }
        return subscription;
    }

    private static HashCode fromString(String hashCode) {
        return HashCodes.fromBytes((byte[])DatatypeConverter.parseHexBinary((String)hashCode));
    }

    public SubscriptionId getOriginalId() {
        return this.originalId;
    }

    public SubscriptionId getParentId() {
        return this.parentId;
    }

    public SubscriptionId getId() {
        return this.id;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getIndexationTime() {
        return this.indexationTime;
    }

    public void setIndexationTime() {
        if (this.indexationTime == -1L) {
            this.indexationTime = System.currentTimeMillis();
        }
    }

    public String getSubscriberUrl() {
        return this.subscriberUrl;
    }

    public String getSubscriptionDestination() {
        return this.subscriptionDestination;
    }

    public NotificationListenerType getType() {
        return this.type;
    }

    public SubscribeProxy getSubscriberProxy() throws ExecutionException {
        return (SubscribeProxy)SUBSCRIBE_PROXIES_CACHE.get((Object)this.subscriberUrl);
    }

    public String getSparqlQuery() {
        return this.sparqlQuery;
    }

    public List<Stub> getStubs() {
        return this.stubs;
    }

    public synchronized Subsubscription[] getSubSubscriptions() {
        if (this.subSubscriptions == null) {
            try {
                List<AtomicQuery> atomicQueries = SparqlDecomposer.getInstance().decompose(this.sparqlQuery).getAtomicQueries();
                this.subSubscriptions = new Subsubscription[atomicQueries.size()];
                for (int i = 0; i < atomicQueries.size(); ++i) {
                    this.subSubscriptions[i] = new Subsubscription(this.originalId, this.id, atomicQueries.get(i), i);
                }
            }
            catch (DecompositionException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.subSubscriptions;
    }

    public synchronized Set<Var> getResultVars() {
        if (this.resultVars == null) {
            this.resultVars = new HashSet<Var>();
            for (String varName : QueryFactory.create((String)this.sparqlQuery).getResultVars()) {
                this.resultVars.add(Var.alloc((String)varName));
            }
        }
        return this.resultVars;
    }

    public synchronized Node getGraphNode() {
        if (this.graphNode == null) {
            this.graphNode = this.getSubSubscriptions()[0].getAtomicQuery().getGraph();
        }
        return this.graphNode;
    }

    public List<Quadruple> toQuadruples() {
        ImmutableList.Builder result = new ImmutableList.Builder();
        Node subscriptionURI = PublishSubscribeUtils.createSubscriptionIdUri(this.id);
        Node subscriptionOriginalURI = PublishSubscribeUtils.createSubscriptionIdUri(this.originalId);
        result.add((Object)new Quadruple(subscriptionOriginalURI, subscriptionURI, PublishSubscribeConstants.SUBSCRIPTION_ID_NODE, Node.createLiteral((String)this.id.toString()), false, false));
        if (this.parentId != null) {
            result.add((Object)new Quadruple(subscriptionOriginalURI, subscriptionURI, PublishSubscribeConstants.SUBSCRIPTION_PARENT_ID_NODE, Node.createLiteral((String)this.parentId.toString()), false, false));
        }
        if (this.originalId != null) {
            result.add((Object)new Quadruple(subscriptionOriginalURI, subscriptionURI, PublishSubscribeConstants.SUBSCRIPTION_ORIGINAL_ID_NODE, PublishSubscribeUtils.createSubscriptionIdUri(this.originalId), false, false));
        }
        result.add((Object)new Quadruple(subscriptionOriginalURI, subscriptionURI, PublishSubscribeConstants.SUBSCRIPTION_SERIALIZED_VALUE_NODE, Node.createLiteral((String)this.sparqlQuery), false, false));
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(this.creationTime);
        result.add((Object)new Quadruple(subscriptionOriginalURI, subscriptionURI, PublishSubscribeConstants.SUBSCRIPTION_CREATION_DATETIME_NODE, Node.createLiteral((String)DatatypeConverter.printDateTime((Calendar)calendar), (RDFDatatype)XSDDatatype.XSDdateTime), false, false));
        result.add((Object)new Quadruple(subscriptionOriginalURI, subscriptionURI, PublishSubscribeConstants.SUBSCRIPTION_TYPE_NODE, Node.createLiteral((String)Short.toString(this.type.convert()), (RDFDatatype)XSDDatatype.XSDshort), false, false));
        calendar.setTimeInMillis(this.indexationTime);
        result.add((Object)new Quadruple(subscriptionOriginalURI, subscriptionURI, PublishSubscribeConstants.SUBSCRIPTION_INDEXATION_DATETIME_NODE, Node.createLiteral((String)DatatypeConverter.printDateTime((Calendar)calendar), (RDFDatatype)XSDDatatype.XSDdateTime), false, false));
        result.add((Object)new Quadruple(subscriptionOriginalURI, subscriptionURI, PublishSubscribeConstants.SUBSCRIPTION_SUBSCRIBER_NODE, Node.createURI((String)this.subscriberUrl), false, false));
        if (this.subscriptionDestination != null) {
            result.add((Object)new Quadruple(subscriptionOriginalURI, subscriptionURI, PublishSubscribeConstants.SUBSCRIPTION_DESTINATION_NODE, Node.createLiteral((String)this.subscriptionDestination), false, false));
        }
        result.add((Object)new Quadruple(subscriptionOriginalURI, subscriptionURI, PublishSubscribeConstants.SUBSCRIPTION_INDEXED_WITH_NODE, Node.createLiteral((String)this.getSubSubscriptions()[0].getId().toString()), false, false));
        for (Stub stub : this.stubs) {
            result.add((Object)new Quadruple(subscriptionOriginalURI, subscriptionURI, PublishSubscribeConstants.SUBSCRIPTION_STUB_NODE, Node.createLiteral((String)(stub.quadrupleHash.toString() + " " + stub.peerUrl)), false, false));
        }
        for (Subsubscription ssubscription : this.getSubSubscriptions()) {
            result.add((Object)new Quadruple(subscriptionOriginalURI, subscriptionURI, PublishSubscribeConstants.SUBSCRIPTION_HAS_SUBSUBSCRIPTION_NODE, PublishSubscribeUtils.createSubSubscriptionIdUri(ssubscription.getId()), false, false));
            result.addAll(ssubscription.toQuadruples());
        }
        return result.build();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof Subscription && this.id.equals((Object)((Subscription)obj).id);
    }

    public String toString() {
        return "Subscription [originalId=" + this.originalId + ", parentId=" + this.parentId + ", id=" + this.id + ", creationTime=" + this.creationTime + ", indexationTime=" + this.indexationTime + ", subscriberUrl=" + this.subscriberUrl + ", subscription destination=" + this.subscriptionDestination + ", sparqlQuery=" + this.sparqlQuery + ", stubs=" + this.stubs + ", type=" + this.type + "]";
    }

    public static void main(String[] args) {
        SubscriptionId id = new SubscriptionId();
        Subscription subscription = new Subscription(id, null, id, System.currentTimeMillis(), System.currentTimeMillis(), "SELECT ?g WHERE { GRAPH ?g { ?s ?p ?o }}", "http://dummy.com", null, NotificationListenerType.BINDING);
        System.out.println(subscription.toQuadruples());
    }

    static {
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().softValues().maximumSize((long)((Integer)EventCloudProperties.SUBSCRIBE_PROXIES_CACHE_MAXIMUM_SIZE.getValue()).intValue());
        if (((Boolean)EventCloudProperties.RECORD_STATS_SUBSCRIPTIONS_CACHE.getValue()).booleanValue()) {
            cacheBuilder.recordStats();
        }
        SUBSCRIBE_PROXIES_CACHE = cacheBuilder.build((CacheLoader)new CacheLoader<String, SubscribeProxy>(){

            public SubscribeProxy load(String subscriberUrl) throws Exception {
                return (SubscribeProxy)ProxyFactory.lookupSubscribeProxy(subscriberUrl);
            }
        });
    }

    public static final class Stub
    implements Serializable {
        private static final long serialVersionUID = 130L;
        public final String peerUrl;
        public final HashCode quadrupleHash;

        public Stub(String peerUrl, HashCode quadrupleHashValue) {
            this.peerUrl = peerUrl;
            this.quadrupleHash = quadrupleHashValue;
        }

        public String toString() {
            return this.peerUrl;
        }
    }
}

