/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.proxies;

import fr.inria.eventcloud.EventCloudsRegistry;
import fr.inria.eventcloud.api.EventCloudId;
import fr.inria.eventcloud.api.properties.UnalterableElaProperty;
import fr.inria.eventcloud.deployment.EventCloudDeployer;
import fr.inria.eventcloud.exceptions.EventCloudIdNotManaged;
import fr.inria.eventcloud.factories.EventCloudsRegistryFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.objectweb.proactive.extensions.p2p.structured.tracker.Tracker;

public class EventCloudCache
implements Serializable {
    private static final long serialVersionUID = 130L;
    private final EventCloudsRegistry registry;
    private EventCloudDeployer deployer;

    public EventCloudCache(String registryUrl, EventCloudId id) throws EventCloudIdNotManaged {
        try {
            this.registry = EventCloudsRegistryFactory.lookupEventCloudsRegistry(registryUrl);
            this.deployer = this.registry.find(id);
            if (this.deployer == null) {
                throw new EventCloudIdNotManaged(id.toString(), registryUrl);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public EventCloudsRegistry getRegistry() {
        return this.registry;
    }

    public EventCloudId getId() {
        return this.deployer.getEventCloudDescription().getId();
    }

    public long getCreationTime() {
        return this.deployer.getEventCloudDescription().getCreationTime();
    }

    public List<UnalterableElaProperty> getElaProperties() {
        return this.deployer.getEventCloudDescription().getElaProperties();
    }

    public List<Tracker> getTrackers() {
        return this.deployer.getTrackers();
    }
}

