/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.proxies;

import fr.inria.eventcloud.configuration.EventCloudProperties;
import fr.inria.eventcloud.monitoring.ProxyMonitoringActions;
import fr.inria.eventcloud.overlay.SemanticPeer;
import fr.inria.eventcloud.proxies.EventCloudCache;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.proactive.Body;
import org.objectweb.proactive.extensions.p2p.structured.AbstractComponent;
import org.objectweb.proactive.extensions.p2p.structured.messages.request.Request;
import org.objectweb.proactive.extensions.p2p.structured.messages.response.Response;
import org.objectweb.proactive.extensions.p2p.structured.overlay.Peer;
import org.objectweb.proactive.extensions.p2p.structured.proxies.Proxy;

public abstract class AbstractProxy
extends AbstractComponent
implements BindingController {
    public static final String MONITORING_SERVICES_CONTROLLER_ITF = "monitoring-services-controller";
    public static final String PROXY_VN = "ProxyVN";
    protected EventCloudCache eventCloudCache;
    protected Proxy proxy;
    protected ProxyMonitoringActions monitoringManager;

    protected AbstractProxy() {
    }

    public void initComponentActivity(Body body) {
        this.configurationProperty = "eventcloud.configuration";
        this.propertiesClass = EventCloudProperties.class;
        super.initComponentActivity(body);
    }

    public void sendv(Request<?> request) {
        this.proxy.sendv(request);
    }

    public void sendv(Request<?> request, Peer peer) {
        this.proxy.sendv(request, peer);
    }

    public Response<?> send(Request<?> request) {
        return this.proxy.send(request);
    }

    public Response<?> send(Request<?> request, Peer peer) {
        return this.proxy.send(request, peer);
    }

    public SemanticPeer selectPeer() {
        return (SemanticPeer)this.proxy.selectPeer();
    }

    public EventCloudCache getEventCloudCache() {
        return this.eventCloudCache;
    }

    public void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException {
        if (!clientItfName.equals(MONITORING_SERVICES_CONTROLLER_ITF)) {
            throw new NoSuchInterfaceException(clientItfName);
        }
        this.monitoringManager = (ProxyMonitoringActions)serverItf;
    }

    public String[] listFc() {
        return new String[]{MONITORING_SERVICES_CONTROLLER_ITF};
    }

    public Object lookupFc(String clientItfName) throws NoSuchInterfaceException {
        if (clientItfName.equals(MONITORING_SERVICES_CONTROLLER_ITF)) {
            return this.monitoringManager;
        }
        throw new NoSuchInterfaceException(clientItfName);
    }

    public void unbindFc(String clientItfName) throws NoSuchInterfaceException {
        if (!clientItfName.equals(MONITORING_SERVICES_CONTROLLER_ITF)) {
            throw new NoSuchInterfaceException(clientItfName);
        }
        this.monitoringManager = null;
    }
}

