/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.providers;

import com.google.common.base.Preconditions;
import fr.inria.eventcloud.configuration.EventCloudProperties;
import fr.inria.eventcloud.datastore.TransactionalTdbDatastore;
import fr.inria.eventcloud.datastore.TransactionalTdbDatastoreBuilder;
import fr.inria.eventcloud.overlay.SemanticCanOverlay;
import java.io.File;
import java.util.UUID;
import org.objectweb.proactive.extensions.p2p.structured.providers.SerializableProvider;

public final class SemanticPersistentOverlayProvider
extends SerializableProvider<SemanticCanOverlay> {
    private static final long serialVersionUID = 130L;
    private String streamUrl;

    public SemanticCanOverlay get() {
        Preconditions.checkNotNull((Object)this.streamUrl);
        File repositoryPath = EventCloudProperties.getRepositoryPath((String)this.streamUrl);
        TransactionalTdbDatastoreBuilder miscDatastoreBuilder = new TransactionalTdbDatastoreBuilder(new File(repositoryPath, "misc")).deleteFilesAfterClose((Boolean)EventCloudProperties.REPOSITORIES_AUTO_REMOVE.getValue());
        if (((Boolean)EventCloudProperties.RECORD_STATS_MISC_DATASTORE.getValue()).booleanValue()) {
            miscDatastoreBuilder.recordStats();
        }
        TransactionalTdbDatastore miscDatastore = miscDatastoreBuilder.build();
        TransactionalTdbDatastore subscriptionsDatastore = new TransactionalTdbDatastoreBuilder(new File(repositoryPath, "subscriptions")).deleteFilesAfterClose((Boolean)EventCloudProperties.REPOSITORIES_AUTO_REMOVE.getValue()).build();
        TransactionalTdbDatastore colanderDatastore = (Boolean)EventCloudProperties.COLANDER_IN_MEMORY.getValue() != false ? new TransactionalTdbDatastoreBuilder().build() : new TransactionalTdbDatastoreBuilder(new File((String)EventCloudProperties.COLANDER_REPOSITORIES_PATH.getValue(), UUID.randomUUID().toString())).deleteFilesAfterClose().build();
        return new SemanticCanOverlay(subscriptionsDatastore, miscDatastore, colanderDatastore);
    }

    public void setStreamUrl(String streamUrl) {
        this.streamUrl = streamUrl;
    }
}

