/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.parsers;

import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import fr.inria.eventcloud.api.PublishSubscribeConstants;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.utils.trigwriter.TriGWriter;
import java.io.OutputStream;
import java.util.List;
import org.openjena.riot.RiotWriter;

public class RdfSerializer {
    public static void triGWriter(OutputStream out, List<Quadruple> quads) {
        TriGWriter.write((OutputStream)out, (Dataset)DatasetFactory.create((DatasetGraph)RdfSerializer.quadruplesToDatasetGraph(quads)));
    }

    public static void nQuadsWriter(OutputStream out, List<Quadruple> quads) {
        RiotWriter.writeNQuads((OutputStream)out, (DatasetGraph)RdfSerializer.quadruplesToDatasetGraph(quads));
    }

    private static DatasetGraph quadruplesToDatasetGraph(List<Quadruple> quads) {
        DatasetGraph dsg = DatasetGraphFactory.createMem();
        for (Quadruple q : quads) {
            if (q.getPredicate() == PublishSubscribeConstants.EVENT_NB_QUADRUPLES_NODE) continue;
            dsg.add(q.getGraph(), q.getSubject(), q.getPredicate(), q.getObject());
        }
        return dsg;
    }
}

