/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.parsers;

import com.hp.hpl.jena.sparql.core.Quad;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.datastore.QuadrupleIterator;
import fr.inria.eventcloud.utils.Callback;
import java.io.InputStream;
import org.openjena.atlas.lib.Sink;
import org.openjena.riot.Lang;
import org.openjena.riot.RiotReader;
import org.openjena.riot.lang.LangNQuads;

public class RdfParser {
    public static final void parse(InputStream in, Quadruple.SerializationFormat format, Callback<Quadruple> action) {
        RdfParser.parse(in, format, action, true);
    }

    public static final void parse(InputStream in, Quadruple.SerializationFormat format, final Callback<Quadruple> action, final boolean checkQuadrupleSyntax) {
        LangNQuads parser;
        Sink<Quad> sink = new Sink<Quad>(){

            public void send(Quad quad) {
                action.execute((Object)new Quadruple(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject(), checkQuadrupleSyntax, false));
            }

            public void close() {
            }

            public void flush() {
            }
        };
        switch (format) {
            case TriG: {
                parser = RiotReader.createParserTriG((InputStream)in, null, (Sink)sink);
                break;
            }
            case NQuads: {
                parser = RiotReader.createParserNQuads((InputStream)in, (Sink)sink);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow SerializationFormat: " + format);
            }
        }
        parser.parse();
        sink.close();
    }

    public static final QuadrupleIterator parse(InputStream in, Quadruple.SerializationFormat format) {
        return RdfParser.parse(in, format, true);
    }

    public static final QuadrupleIterator parse(InputStream in, Quadruple.SerializationFormat format, boolean checkQuadrupleSyntax) {
        return new QuadrupleIterator(RiotReader.createIteratorQuads((InputStream)in, (Lang)format.toJenaLang(), null), checkQuadrupleSyntax, false);
    }
}

