/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.overlay.can;

import com.hp.hpl.jena.graph.Node;
import java.net.URI;
import java.net.URISyntaxException;
import org.apfloat.Apfloat;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.elements.StringElement;

public class SemanticElement
extends StringElement {
    private static final long serialVersionUID = 130L;
    protected static String EMPTY_STRING_ROUTING_CHARACTER = "\u00a2";

    public SemanticElement(Node value) {
        super(SemanticElement.removePrefix(value));
    }

    public SemanticElement(Apfloat value) {
        super(value);
    }

    protected SemanticElement(String value) {
        super(value);
    }

    public static final String removePrefix(Node value) {
        if (value.isURI()) {
            int schemeColonSlashSlashLength;
            String content = value.getURI();
            int slashIndex = content.lastIndexOf(47);
            int sharpIndex = content.lastIndexOf(35);
            int lastCharIndex = content.length() - 1;
            if (slashIndex == lastCharIndex || sharpIndex == lastCharIndex) {
                content = content.substring(0, lastCharIndex);
                slashIndex = content.lastIndexOf(47);
                sharpIndex = content.lastIndexOf(35);
            }
            URI uri = null;
            try {
                uri = new URI(content);
            }
            catch (URISyntaxException e) {
                return content;
            }
            if (uri.getScheme() != null && slashIndex < (schemeColonSlashSlashLength = uri.getScheme().length() + 3) && sharpIndex == -1) {
                if (content.startsWith("www.", schemeColonSlashSlashLength)) {
                    return content.substring(schemeColonSlashSlashLength + 4);
                }
                return content.substring(uri.getScheme().length() + 3);
            }
            if (slashIndex > sharpIndex) {
                return content.substring(slashIndex + 1);
            }
            if (slashIndex < sharpIndex) {
                return content.substring(sharpIndex + 1);
            }
            return content;
        }
        if (value.isLiteral()) {
            String literal = value.getLiteralLexicalForm();
            if (literal.isEmpty()) {
                return EMPTY_STRING_ROUTING_CHARACTER;
            }
            return literal;
        }
        if (value.isBlank()) {
            return value.getBlankNodeLabel();
        }
        if (value.isVariable()) {
            return value.getName();
        }
        throw new IllegalArgumentException("Unknown node type: " + value.getClass());
    }

    protected StringElement newStringElement(Apfloat apfloat) {
        return new SemanticElement(apfloat);
    }
}

