/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.overlay.can;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Node_ANY;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.api.QuadruplePattern;
import fr.inria.eventcloud.overlay.can.SemanticElement;
import org.objectweb.proactive.extensions.p2p.structured.configuration.P2PStructuredProperties;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.coordinates.Coordinate;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.elements.Element;

public final class SemanticCoordinateFactory {
    private SemanticCoordinateFactory() {
    }

    public static Coordinate<SemanticElement> newSemanticCoordinate(QuadruplePattern quadruplePattern) {
        return SemanticCoordinateFactory.newSemanticCoordinate(quadruplePattern.getGraph(), quadruplePattern.getSubject(), quadruplePattern.getPredicate(), quadruplePattern.getObject());
    }

    public static Coordinate<SemanticElement> newSemanticCoordinate(Quadruple quad) {
        return SemanticCoordinateFactory.newSemanticCoordinate(quad.getGraph(), quad.getSubject(), quad.getPredicate(), quad.getObject());
    }

    public static Coordinate<SemanticElement> newSemanticCoordinate(Node graph, Node subject, Node predicate, Node object) {
        return new Coordinate((Element[])new SemanticElement[]{SemanticCoordinateFactory.createSemanticElementWithVars(graph), SemanticCoordinateFactory.createSemanticElementWithVars(subject), SemanticCoordinateFactory.createSemanticElementWithVars(predicate), SemanticCoordinateFactory.createSemanticElementWithVars(object)});
    }

    private static SemanticElement createSemanticElementWithVars(Node n) {
        if (!SemanticCoordinateFactory.isVariable(n)) {
            return new SemanticElement(n);
        }
        return null;
    }

    private static boolean isVariable(Node n) {
        return n == null || n.isVariable() || n instanceof Node_ANY;
    }

    public static String toNTripleSyntax(String tripleElt) {
        if (tripleElt.length() > 0 && tripleElt.charAt(0) != '?' && tripleElt.charAt(0) != '\"') {
            StringBuilder triple = new StringBuilder("<");
            triple.append(tripleElt);
            triple.append('>');
            return triple.toString();
        }
        return tripleElt;
    }

    protected static Coordinate<SemanticElement> newSemanticCoordinate(String value) {
        SemanticElement[] elts = new SemanticElement[((Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue()).byteValue()];
        for (int i = 0; i < (Byte)P2PStructuredProperties.CAN_NB_DIMENSIONS.getValue(); ++i) {
            elts[i] = new SemanticElement(value);
        }
        return new Coordinate((Element[])elts);
    }
}

