/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.overlay;

import com.hp.hpl.jena.rdf.model.StmtIterator;
import fr.inria.eventcloud.api.CompoundEvent;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.api.QuadruplePattern;
import fr.inria.eventcloud.api.exceptions.MalformedSparqlQueryException;
import fr.inria.eventcloud.api.responses.SparqlAskResponse;
import fr.inria.eventcloud.api.responses.SparqlConstructResponse;
import fr.inria.eventcloud.api.responses.SparqlDescribeResponse;
import fr.inria.eventcloud.api.responses.SparqlResponse;
import fr.inria.eventcloud.api.responses.SparqlSelectResponse;
import fr.inria.eventcloud.api.wrappers.ModelWrapper;
import fr.inria.eventcloud.api.wrappers.ResultSetWrapper;
import fr.inria.eventcloud.configuration.EventCloudProperties;
import fr.inria.eventcloud.messages.request.can.AddQuadrupleRequest;
import fr.inria.eventcloud.messages.request.can.ContainsQuadrupleRequest;
import fr.inria.eventcloud.messages.request.can.CountQuadruplePatternRequest;
import fr.inria.eventcloud.messages.request.can.DeleteQuadrupleRequest;
import fr.inria.eventcloud.messages.request.can.DeleteQuadruplesRequest;
import fr.inria.eventcloud.messages.request.can.IndexSubscriptionRequest;
import fr.inria.eventcloud.messages.request.can.PublishQuadrupleRequest;
import fr.inria.eventcloud.messages.request.can.QuadruplePatternRequest;
import fr.inria.eventcloud.messages.response.can.BooleanForwardResponse;
import fr.inria.eventcloud.messages.response.can.CountQuadruplePatternResponse;
import fr.inria.eventcloud.messages.response.can.QuadruplePatternResponse;
import fr.inria.eventcloud.overlay.SemanticCanOverlay;
import fr.inria.eventcloud.overlay.SemanticPeer;
import fr.inria.eventcloud.overlay.SemanticRequestResponseManager;
import fr.inria.eventcloud.parsers.RdfParser;
import fr.inria.eventcloud.pubsub.Subscription;
import fr.inria.eventcloud.utils.Callback;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.proactive.Body;
import org.objectweb.proactive.annotation.multiactivity.MemberOf;
import org.objectweb.proactive.api.PAFuture;
import org.objectweb.proactive.core.util.wrapper.BooleanWrapper;
import org.objectweb.proactive.extensions.p2p.structured.messages.request.Request;
import org.objectweb.proactive.extensions.p2p.structured.overlay.PeerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.soceda.socialfilter.relationshipstrengthengine.RelationshipStrengthEngineManager;

public class SemanticPeerImpl
extends PeerImpl
implements SemanticPeer,
BindingController {
    private static final long serialVersionUID = 130L;
    private static final Logger log = LoggerFactory.getLogger(SemanticPeerImpl.class);
    public static final String SEMANTIC_PEER_ADL = "fr.inria.eventcloud.overlay.SemanticPeer";
    public static final String SOCIAL_FILTER_SERVICES_ITF = "social-filter-services";

    public void initComponentActivity(Body body) {
        this.configurationProperty = "eventcloud.configuration";
        this.propertiesClass = EventCloudProperties.class;
        super.initComponentActivity(body);
    }

    @Override
    @MemberOf(value="parallel")
    public void publish(Quadruple quad) {
        if (quad.getPublicationTime() == -1L) {
            quad.setPublicationTime();
        }
        super.sendv((Request)new PublishQuadrupleRequest(quad));
    }

    @Override
    @MemberOf(value="parallel")
    public void publish(CompoundEvent event) {
        long publicationTime = System.currentTimeMillis();
        Quadruple metaQuadruple = CompoundEvent.createMetaQuadruple((CompoundEvent)event);
        metaQuadruple.setPublicationTime(publicationTime);
        this.publish(metaQuadruple);
        for (Quadruple quad : event) {
            quad.setPublicationTime(publicationTime);
            this.publish(quad);
        }
    }

    @Override
    @MemberOf(value="parallel")
    public void indexSubscription(Subscription subscription) {
        subscription.setIndexationTime();
        super.sendv((Request)new IndexSubscriptionRequest(subscription));
    }

    @MemberOf(value="parallel")
    public boolean add(Quadruple quad) {
        PAFuture.waitFor((Object)super.send((Request)new AddQuadrupleRequest(quad)));
        return true;
    }

    @MemberOf(value="parallel")
    private BooleanWrapper addAsync(Quadruple quad) {
        PAFuture.waitFor((Object)super.send((Request)new AddQuadrupleRequest(quad)));
        return new BooleanWrapper(true);
    }

    @MemberOf(value="parallel")
    public boolean add(Collection<Quadruple> quads) {
        ArrayList<BooleanWrapper> results = new ArrayList<BooleanWrapper>();
        for (Quadruple quad : quads) {
            results.add(this.addAsync(quad));
        }
        PAFuture.waitForAll(results);
        return true;
    }

    @MemberOf(value="parallel")
    public boolean add(URL url, Quadruple.SerializationFormat format) {
        try {
            final ArrayList results = new ArrayList();
            InputStream in = url.openConnection().getInputStream();
            RdfParser.parse(in, format, new Callback<Quadruple>(){

                public void execute(Quadruple quad) {
                    results.add(SemanticPeerImpl.this.addAsync(quad));
                }
            });
            in.close();
            PAFuture.waitForAll(results);
            return true;
        }
        catch (IOException ioe) {
            log.error("An error occurred when reading from the given URL", (Throwable)ioe);
            return false;
        }
    }

    @MemberOf(value="parallel")
    public boolean contains(Quadruple quad) {
        return ((BooleanForwardResponse)((Object)PAFuture.getFutureValue((Object)super.send((Request)new ContainsQuadrupleRequest(quad))))).getResult();
    }

    @MemberOf(value="parallel")
    public boolean delete(Quadruple quad) {
        PAFuture.waitFor((Object)super.send((Request)new DeleteQuadrupleRequest(quad)));
        return true;
    }

    @MemberOf(value="parallel")
    public BooleanWrapper deleteAsync(Quadruple quad) {
        PAFuture.waitFor((Object)super.send((Request)new DeleteQuadrupleRequest(quad)));
        return new BooleanWrapper(true);
    }

    @MemberOf(value="parallel")
    public boolean delete(Collection<Quadruple> quads) {
        ArrayList<BooleanWrapper> results = new ArrayList<BooleanWrapper>();
        for (Quadruple quad : quads) {
            results.add(this.deleteAsync(quad));
        }
        PAFuture.waitForAll(results);
        return true;
    }

    @MemberOf(value="parallel")
    public List<Quadruple> delete(QuadruplePattern quadPattern) {
        QuadruplePatternResponse response = (QuadruplePatternResponse)((Object)PAFuture.getFutureValue((Object)super.send((Request)new DeleteQuadruplesRequest(quadPattern.getGraph(), quadPattern.getSubject(), quadPattern.getPredicate(), quadPattern.getObject()))));
        return (List)response.getResult();
    }

    @MemberOf(value="parallel")
    public long count(QuadruplePattern quadPattern) {
        return (Long)((CountQuadruplePatternResponse)((Object)PAFuture.getFutureValue((Object)super.send((Request)new CountQuadruplePatternRequest(quadPattern.getGraph(), quadPattern.getSubject(), quadPattern.getPredicate(), quadPattern.getObject()))))).getResult();
    }

    @MemberOf(value="parallel")
    public long count(String sparqlQuery) throws MalformedSparqlQueryException {
        SparqlResponse<?> response = this.executeSparqlQuery(sparqlQuery);
        if (response instanceof SparqlAskResponse) {
            return (Boolean)((SparqlAskResponse)response).getResult() != false ? 1L : 0L;
        }
        if (response instanceof SparqlConstructResponse) {
            StmtIterator it = ((ModelWrapper)((SparqlConstructResponse)response).getResult()).listStatements();
            long result = 0L;
            while (it.hasNext()) {
                it.next();
                ++result;
            }
            return result;
        }
        if (response instanceof SparqlSelectResponse) {
            ResultSetWrapper it = (ResultSetWrapper)((SparqlSelectResponse)response).getResult();
            long result = 0L;
            while (it.hasNext()) {
                it.nextBinding();
                ++result;
            }
            return result;
        }
        return -1L;
    }

    @MemberOf(value="parallel")
    public List<Quadruple> find(QuadruplePattern quadPattern) {
        return (List)((QuadruplePatternResponse)((Object)PAFuture.getFutureValue((Object)super.send((Request)new QuadruplePatternRequest(quadPattern.getGraph(), quadPattern.getSubject(), quadPattern.getPredicate(), quadPattern.getObject()))))).getResult();
    }

    @MemberOf(value="parallel")
    public SparqlResponse<?> executeSparqlQuery(String sparqlQuery) throws MalformedSparqlQueryException {
        if ((sparqlQuery = sparqlQuery.trim()).startsWith("ASK")) {
            return this.executeSparqlAsk(sparqlQuery);
        }
        if (sparqlQuery.startsWith("CONSTRUCT")) {
            return this.executeSparqlConstruct(sparqlQuery);
        }
        if (sparqlQuery.startsWith("DESCRIBE")) {
            return this.executeSparqlDescribe(sparqlQuery);
        }
        if (sparqlQuery.startsWith("SELECT")) {
            return this.executeSparqlSelect(sparqlQuery);
        }
        throw new IllegalArgumentException("Unknow query form for query: " + sparqlQuery);
    }

    @MemberOf(value="parallel")
    public SparqlAskResponse executeSparqlAsk(String sparqlAskQuery) throws MalformedSparqlQueryException {
        return ((SemanticRequestResponseManager)this.overlay.getRequestResponseManager()).executeSparqlAsk(sparqlAskQuery, this.overlay);
    }

    @MemberOf(value="parallel")
    public SparqlConstructResponse executeSparqlConstruct(String sparqlConstruct) throws MalformedSparqlQueryException {
        return ((SemanticRequestResponseManager)this.overlay.getRequestResponseManager()).executeSparqlConstruct(sparqlConstruct, this.overlay);
    }

    @MemberOf(value="parallel")
    public SparqlDescribeResponse executeSparqlDescribe(String sparqlDescribeQuery) throws MalformedSparqlQueryException {
        throw new UnsupportedOperationException();
    }

    @MemberOf(value="parallel")
    public SparqlSelectResponse executeSparqlSelect(String sparqlSelect) throws MalformedSparqlQueryException {
        return ((SemanticRequestResponseManager)this.overlay.getRequestResponseManager()).executeSparqlSelect(sparqlSelect, this.overlay);
    }

    public void bindFc(String clientItfName, Object serverItf) throws NoSuchInterfaceException {
        if (!clientItfName.equals(SOCIAL_FILTER_SERVICES_ITF)) {
            throw new NoSuchInterfaceException(clientItfName);
        }
        ((SemanticCanOverlay)this.overlay).setSocialFilter((RelationshipStrengthEngineManager)serverItf);
    }

    public String[] listFc() {
        return new String[]{SOCIAL_FILTER_SERVICES_ITF};
    }

    public Object lookupFc(String clientItfName) throws NoSuchInterfaceException {
        if (clientItfName.equals(SOCIAL_FILTER_SERVICES_ITF)) {
            return ((SemanticCanOverlay)this.overlay).getSocialFilter();
        }
        throw new NoSuchInterfaceException(clientItfName);
    }

    public void unbindFc(String clientItfName) throws NoSuchInterfaceException {
        if (!clientItfName.equals(SOCIAL_FILTER_SERVICES_ITF)) {
            throw new NoSuchInterfaceException(clientItfName);
        }
        ((SemanticCanOverlay)this.overlay).setSocialFilter(null);
    }
}

