/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.overlay;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.hash.HashCode;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import fr.inria.eventcloud.api.PublishSubscribeConstants;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.api.QuadruplePattern;
import fr.inria.eventcloud.api.SubscriptionId;
import fr.inria.eventcloud.configuration.EventCloudProperties;
import fr.inria.eventcloud.datastore.AccessMode;
import fr.inria.eventcloud.datastore.QuadrupleIterator;
import fr.inria.eventcloud.datastore.TransactionalDatasetGraph;
import fr.inria.eventcloud.datastore.TransactionalTdbDatastore;
import fr.inria.eventcloud.overlay.SemanticData;
import fr.inria.eventcloud.overlay.SemanticPeer;
import fr.inria.eventcloud.overlay.SemanticRequestResponseManager;
import fr.inria.eventcloud.overlay.can.SemanticElement;
import fr.inria.eventcloud.overlay.can.SemanticZone;
import fr.inria.eventcloud.pubsub.PublishSubscribeUtils;
import fr.inria.eventcloud.pubsub.SubscriberConnectionFailure;
import fr.inria.eventcloud.pubsub.Subscription;
import fr.inria.eventcloud.pubsub.notifications.NotificationId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.objectweb.proactive.api.PAActiveObject;
import org.objectweb.proactive.extensions.p2p.structured.operations.can.JoinIntroduceOperation;
import org.objectweb.proactive.extensions.p2p.structured.operations.can.JoinIntroduceResponseOperation;
import org.objectweb.proactive.extensions.p2p.structured.overlay.Peer;
import org.objectweb.proactive.extensions.p2p.structured.overlay.RequestResponseManager;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.CanOverlay;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.Zone;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.coordinates.Coordinate;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.zone.elements.Element;
import org.objectweb.proactive.extensions.p2p.structured.utils.HomogenousPair;
import org.soceda.socialfilter.relationshipstrengthengine.RelationshipStrengthEngineManager;

public class SemanticCanOverlay
extends CanOverlay<SemanticElement> {
    private RelationshipStrengthEngineManager socialFilter;
    private final LoadingCache<String, SemanticPeer> peerStubsCache;
    private final LoadingCache<SubscriptionId, Subscription> subscriptionsCache;
    private final ConcurrentMap<SubscriptionId, SubscriberConnectionFailure> subscriberConnectionFailures;
    private final TransactionalTdbDatastore miscDatastore;
    private final TransactionalTdbDatastore subscriptionsDatastore;
    private SetMultimap<NotificationId, HashCode> sentQuadrupleHashValues;

    public SemanticCanOverlay(final TransactionalTdbDatastore subscriptionsDatastore, TransactionalTdbDatastore miscDatastore, TransactionalTdbDatastore colanderDatastore) {
        super((RequestResponseManager)new SemanticRequestResponseManager(colanderDatastore));
        this.miscDatastore = miscDatastore;
        this.subscriptionsDatastore = subscriptionsDatastore;
        this.miscDatastore.open();
        this.subscriptionsDatastore.open();
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().softValues().maximumSize((long)((Integer)EventCloudProperties.PEER_STUBS_CACHE_MAXIMUM_SIZE.getValue()).intValue());
        if (((Boolean)EventCloudProperties.RECORD_STATS_PEER_STUBS_CACHE.getValue()).booleanValue()) {
            cacheBuilder.recordStats();
        }
        this.peerStubsCache = cacheBuilder.build((CacheLoader)new CacheLoader<String, SemanticPeer>(){

            public SemanticPeer load(String peerUrl) throws Exception {
                return (SemanticPeer)PAActiveObject.lookupActive(SemanticPeer.class, (String)peerUrl);
            }
        });
        cacheBuilder = CacheBuilder.newBuilder().softValues().maximumSize((long)((Integer)EventCloudProperties.SUBSCRIPTIONS_CACHE_MAXIMUM_SIZE.getValue()).intValue());
        if (((Boolean)EventCloudProperties.RECORD_STATS_SUBSCRIPTIONS_CACHE.getValue()).booleanValue()) {
            cacheBuilder.recordStats();
        }
        this.subscriptionsCache = cacheBuilder.build((CacheLoader)new CacheLoader<SubscriptionId, Subscription>(){

            public Subscription load(SubscriptionId key) throws SubscriptionNotFoundException {
                Subscription subscription = Subscription.parseFrom(subscriptionsDatastore, key);
                if (subscription == null) {
                    throw new SubscriptionNotFoundException();
                }
                return subscription;
            }
        });
        this.subscriberConnectionFailures = new MapMaker().softValues().makeMap();
        if (EventCloudProperties.isSbce2PubSubAlgorithmUsed()) {
            this.sentQuadrupleHashValues = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create((int)((Integer)EventCloudProperties.MAO_SOFT_LIMIT_SUBSCRIBE_PROXIES.getValue()), (int)((Integer)EventCloudProperties.AVERAGE_NB_QUADRUPLES_PER_COMPOUND_EVENT.getValue())));
        }
    }

    public boolean markAsSent(NotificationId notificationId, Quadruple quadruple) {
        return this.sentQuadrupleHashValues.put((Object)notificationId, (Object)quadruple.hashValue());
    }

    public void dropAsSent(NotificationId notificationId) {
        this.sentQuadrupleHashValues.removeAll((Object)notificationId);
    }

    public boolean hasSocialFilter() {
        return this.socialFilter != null;
    }

    public RelationshipStrengthEngineManager getSocialFilter() {
        return this.socialFilter;
    }

    public void setSocialFilter(RelationshipStrengthEngineManager socialFilter) {
        this.socialFilter = socialFilter;
    }

    public final Subscription findSubscription(SubscriptionId id) {
        try {
            return (Subscription)this.subscriptionsCache.get((Object)id);
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public final Subscription findSubscription(final TransactionalDatasetGraph dataset, final SubscriptionId id) {
        try {
            return (Subscription)this.subscriptionsCache.get((Object)id, (Callable)new Callable<Subscription>(){

                @Override
                public Subscription call() throws Exception {
                    return Subscription.parseFrom(dataset, id);
                }
            });
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Subscription " + id + " not found in cache and datastore");
        }
    }

    public final SemanticPeer findPeerStub(String peerUrl) {
        try {
            return (SemanticPeer)this.peerStubsCache.get((Object)peerUrl);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Stub associated to URL " + peerUrl + " not found in cache and the construction of the remote reference failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeSubscription(Subscription subscription) {
        this.subscriptionsCache.put((Object)subscription.getId(), (Object)subscription);
        TransactionalDatasetGraph txnGraph = this.subscriptionsDatastore.begin(AccessMode.WRITE);
        try {
            txnGraph.add(subscription.toQuadruples());
            txnGraph.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            txnGraph.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSubscriptions(SubscriptionId originalSubscriptionId, boolean useBindingNotificationListener) {
        Node oidNode = PublishSubscribeUtils.createSubscriptionIdUri(originalSubscriptionId);
        LoadingCache<SubscriptionId, Subscription> loadingCache = this.subscriptionsCache;
        synchronized (loadingCache) {
            TransactionalDatasetGraph txnGraph = this.subscriptionsDatastore.begin(AccessMode.WRITE);
            try {
                if (useBindingNotificationListener) {
                    txnGraph.delete(new QuadruplePattern(Node.ANY, oidNode, PublishSubscribeConstants.QUADRUPLE_MATCHES_SUBSCRIPTION_NODE, Node.ANY));
                }
                txnGraph.delete(new QuadruplePattern(oidNode, Node.ANY, Node.ANY, Node.ANY));
                txnGraph.commit();
            }
            finally {
                txnGraph.end();
            }
            this.subscriptionsCache.invalidate((Object)originalSubscriptionId);
        }
    }

    public TransactionalTdbDatastore getMiscDatastore() {
        return this.miscDatastore;
    }

    public TransactionalTdbDatastore getSubscriptionsDatastore() {
        return this.subscriptionsDatastore;
    }

    public ConcurrentMap<SubscriptionId, SubscriberConnectionFailure> getSubscriberConnectionFailures() {
        return this.subscriberConnectionFailures;
    }

    public String dump() {
        StringBuilder result = new StringBuilder(super.dump());
        if (((Boolean)EventCloudProperties.RECORD_STATS_SUBSCRIPTIONS_CACHE.getValue()).booleanValue()) {
            result.append("Subscriptions cache:\n  ");
            result.append(this.subscriptionsCache.stats());
            result.append('\n');
        }
        if (((Boolean)EventCloudProperties.RECORD_STATS_PEER_STUBS_CACHE.getValue()).booleanValue()) {
            result.append("Peer stubs cache:\n  ");
            result.append(this.peerStubsCache.stats());
            result.append('\n');
        }
        if (((Boolean)EventCloudProperties.RECORD_STATS_SUBSCRIBE_PROXIES_CACHE.getValue()).booleanValue()) {
            result.append("Subscribe proxies cache:\n  ");
            result.append(Subscription.SUBSCRIBE_PROXIES_CACHE.stats());
            result.append('\n');
        }
        if (((Boolean)EventCloudProperties.RECORD_STATS_MISC_DATASTORE.getValue()).booleanValue()) {
            result.append("Misc datastore stats recorded with ");
            result.append(this.miscDatastore.getStatsRecorder().getClass());
            result.append('\n');
            result.append("Misc datastore size: ");
            result.append(this.miscDatastore.getStatsRecorder().getNbQuads());
            result.append('\n');
        }
        if (this.sentQuadrupleHashValues != null) {
            result.append("Nb entries contained by sentQuadrupleHashValues datastructure: ");
            result.append(this.sentQuadrupleHashValues.size());
            result.append('\n');
        }
        return result.toString();
    }

    protected Zone<SemanticElement> newZone() {
        return new SemanticZone();
    }

    public void assignDataReceived(Serializable dataReceived) {
        SemanticData semanticDataReceived = (SemanticData)dataReceived;
        SemanticCanOverlay.store(this.miscDatastore, semanticDataReceived.getMiscData());
        SemanticCanOverlay.store(this.subscriptionsDatastore, semanticDataReceived.getSubscriptions());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void store(TransactionalTdbDatastore datastore, Collection<Quadruple> quadruples) {
        if (quadruples == null || quadruples.size() == 0) {
            return;
        }
        TransactionalDatasetGraph txnGraph = datastore.begin(AccessMode.WRITE);
        try {
            txnGraph.add(quadruples);
            txnGraph.commit();
        }
        finally {
            txnGraph.end();
        }
    }

    public SemanticData retrieveAllData() {
        return new SemanticData(SemanticCanOverlay.retrieveAll(this.miscDatastore), SemanticCanOverlay.retrieveAll(this.subscriptionsDatastore));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Quadruple> retrieveAll(TransactionalTdbDatastore datastore) {
        TransactionalDatasetGraph txnGraph = datastore.begin(AccessMode.READ_ONLY);
        try {
            ArrayList arrayList = Lists.newArrayList((Iterator)txnGraph.find(QuadruplePattern.ANY));
            return arrayList;
        }
        finally {
            txnGraph.end();
        }
    }

    public void join(Peer landmarkPeer) {
        if (this.miscDatastore.getStatsRecorder() != null) {
            this.miscDatastore.getStatsRecorder().sync();
        }
        super.join(landmarkPeer);
    }

    public JoinIntroduceResponseOperation<SemanticElement> handleJoinIntroduceMessage(JoinIntroduceOperation<SemanticElement> msg) {
        if (this.miscDatastore.getStatsRecorder() != null) {
            this.miscDatastore.getStatsRecorder().sync();
        }
        return super.handleJoinIntroduceMessage(msg);
    }

    public SemanticData retrieveDataIn(Object interval) {
        return this.retrieveDataIn((Zone<SemanticElement>)((Zone)interval), false);
    }

    public SemanticData removeDataIn(Object interval) {
        return this.retrieveDataIn((Zone<SemanticElement>)((Zone)interval), true);
    }

    private SemanticData retrieveDataIn(Zone<SemanticElement> zone, boolean remove) {
        List<Quadruple> miscData = this.retrieveMiscDataIn(zone, remove);
        List<Quadruple> subscriptions = this.retrieveSubscriptionsIn(zone, remove);
        return new SemanticData(miscData, subscriptions);
    }

    private List<Quadruple> retrieveMiscDataIn(Zone<SemanticElement> zone, boolean remove) {
        ArrayList<Quadruple> result = new ArrayList<Quadruple>();
        TransactionalDatasetGraph txnGraph = this.miscDatastore.begin(AccessMode.READ_ONLY);
        try {
            QuadrupleIterator it = txnGraph.find(QuadruplePattern.ANY);
            while (it.hasNext()) {
                Quadruple quad = it.next();
                SemanticElement graph = new SemanticElement(quad.getGraph());
                SemanticElement subject = new SemanticElement(quad.getSubject());
                SemanticElement predicate = new SemanticElement(quad.getPredicate());
                SemanticElement object = new SemanticElement(quad.getObject());
                if (graph.compareTo(zone.getLowerBound((byte)0)) < 0 || graph.compareTo(zone.getUpperBound((byte)0)) >= 0 || subject.compareTo(zone.getLowerBound((byte)1)) < 0 || subject.compareTo(zone.getUpperBound((byte)1)) >= 0 || predicate.compareTo(zone.getLowerBound((byte)2)) < 0 || predicate.compareTo(zone.getUpperBound((byte)2)) >= 0 || object.compareTo(zone.getLowerBound((byte)3)) < 0 || object.compareTo(zone.getUpperBound((byte)3)) >= 0) continue;
                result.add(quad);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            txnGraph.end();
        }
        if (remove) {
            SemanticCanOverlay.delete(this.miscDatastore, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Quadruple> retrieveSubscriptionsIn(Zone<SemanticElement> zone, boolean remove) {
        TransactionalDatasetGraph txnGraph = this.subscriptionsDatastore.begin(AccessMode.READ_ONLY);
        String q = SemanticCanOverlay.createFindSubscriptionsQuery();
        QueryExecution qexec = QueryExecutionFactory.create((Query)QueryFactory.create((String)q), (Dataset)txnGraph.getUnderlyingDataset());
        ArrayList<Node> subscriptionIdsToCopy = new ArrayList<Node>();
        ArrayList<Node> subscriptionIdsToDelete = new ArrayList<Node>();
        try {
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                boolean oIsVar;
                boolean pIsVar;
                boolean sIsVar;
                boolean gIsVar;
                String owp;
                String pwp;
                String swp;
                Binding binding = results.nextBinding();
                Node oid = binding.get(Var.alloc((String)"oid"));
                Node g = binding.get(Var.alloc((String)"g"));
                Node s = binding.get(Var.alloc((String)"s"));
                Node p = binding.get(Var.alloc((String)"p"));
                Node o = binding.get(Var.alloc((String)"o"));
                String gwp = SemanticElement.removePrefix(g);
                if (SemanticCanOverlay.isSubscriptionManagedByZone(zone, gwp, swp = SemanticElement.removePrefix(s), pwp = SemanticElement.removePrefix(p), owp = SemanticElement.removePrefix(o), gIsVar = SemanticCanOverlay.isVariable(g), sIsVar = SemanticCanOverlay.isVariable(s), pIsVar = SemanticCanOverlay.isVariable(p), oIsVar = SemanticCanOverlay.isVariable(o))) {
                    subscriptionIdsToCopy.add(oid);
                }
                if (!remove || SemanticCanOverlay.isSubscriptionManagedByZone((Zone<SemanticElement>)this.zone, gwp, swp, pwp, owp, gIsVar, sIsVar, pIsVar, oIsVar)) continue;
                subscriptionIdsToDelete.add(oid);
            }
        }
        finally {
            qexec.close();
            txnGraph.end();
        }
        txnGraph = this.subscriptionsDatastore.begin(AccessMode.READ_ONLY);
        ArrayList<Quadruple> result = new ArrayList<Quadruple>();
        try {
            for (Node graph : subscriptionIdsToCopy) {
                QuadrupleIterator it = txnGraph.find(graph, Node.ANY, Node.ANY, Node.ANY);
                while (it.hasNext()) {
                    result.add(it.next());
                }
                it = txnGraph.find(Node.ANY, graph, PublishSubscribeConstants.QUADRUPLE_MATCHES_SUBSCRIPTION_NODE, Node.ANY);
                while (it.hasNext()) {
                    result.add(it.next());
                }
            }
        }
        finally {
            txnGraph.end();
        }
        if (remove) {
            txnGraph = this.subscriptionsDatastore.begin(AccessMode.WRITE);
            try {
                for (Node graph : subscriptionIdsToDelete) {
                    txnGraph.delete(graph, Node.ANY, Node.ANY, Node.ANY);
                    txnGraph.delete(Node.ANY, graph, PublishSubscribeConstants.QUADRUPLE_MATCHES_SUBSCRIPTION_NODE, Node.ANY);
                }
            }
            finally {
                txnGraph.end();
            }
        }
        return result;
    }

    private static boolean isVariable(Node n) {
        return n.isLiteral() && n.getLiteralDatatypeURI().equals("urn:ec:var");
    }

    private static boolean isSubscriptionManagedByZone(Zone<SemanticElement> zone, String gwp, String swp, String pwp, String owp, boolean gIsVar, boolean sIsVar, boolean pIsVar, boolean oIsVar) {
        String graphLowerBound = ((SemanticElement)zone.getLowerBound((byte)0)).getValue();
        String graphUpperBound = ((SemanticElement)zone.getUpperBound((byte)0)).getValue();
        String subjectLowerBound = ((SemanticElement)zone.getLowerBound((byte)1)).getValue();
        String subjectUpperBound = ((SemanticElement)zone.getUpperBound((byte)1)).getValue();
        String predicateLowerBound = ((SemanticElement)zone.getLowerBound((byte)2)).getValue();
        String predicateUpperBound = ((SemanticElement)zone.getUpperBound((byte)2)).getValue();
        String objectLowerBound = ((SemanticElement)zone.getLowerBound((byte)3)).getValue();
        String objectUpperBound = ((SemanticElement)zone.getUpperBound((byte)3)).getValue();
        return (gIsVar || gwp.compareTo(graphLowerBound) >= 0 && gwp.compareTo(graphUpperBound) < 0) && (sIsVar || swp.compareTo(subjectLowerBound) >= 0 && swp.compareTo(subjectUpperBound) < 0) && (pIsVar || pwp.compareTo(predicateLowerBound) >= 0 && pwp.compareTo(predicateUpperBound) < 0) && (oIsVar || owp.compareTo(objectLowerBound) >= 0 && owp.compareTo(objectUpperBound) < 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void delete(TransactionalTdbDatastore datastore, Collection<Quadruple> quadruples) {
        TransactionalDatasetGraph txnGraph = datastore.begin(AccessMode.WRITE);
        try {
            for (Quadruple q : quadruples) {
                txnGraph.delete(q);
            }
            txnGraph.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            txnGraph.end();
        }
    }

    private static String createFindSubscriptionsQuery() {
        char[] vars = new char[]{'g', 's', 'p', 'o'};
        StringBuilder result = new StringBuilder();
        result.append("PREFIX ec: <");
        result.append((String)EventCloudProperties.FILTER_FUNCTIONS_NS.getValue());
        result.append(">\n");
        result.append("SELECT ?oid ?g ?s ?p ?o WHERE {\n  GRAPH ?oid {\n");
        result.append("    ?oid <");
        result.append("urn:ec:s:iref");
        result.append("> ?iref .\n");
        result.append("    ?ssid <");
        result.append("urn:ec:ss:id");
        result.append("> ?iref .\n");
        for (int i = 0; i < vars.length; ++i) {
            result.append("    ?ssid <");
            result.append("urn:ec:ss:");
            result.append(vars[i]);
            result.append("> ?");
            result.append(vars[i]);
            result.append(" .\n");
        }
        result.append("  }\n\n}");
        return result.toString();
    }

    protected HomogenousPair<? extends Zone<SemanticElement>> splitZones(byte dimension) {
        if (!((Boolean)EventCloudProperties.STATIC_LOAD_BALANCING.getValue()).booleanValue() || ((Boolean)EventCloudProperties.STATIC_LOAD_BALANCING.getValue()).booleanValue() && this.miscDatastore.getStatsRecorder() == null) {
            return super.splitZones(dimension);
        }
        SemanticElement estimatedMiddle = this.miscDatastore.getStatsRecorder().computeSplitEstimation(dimension);
        try {
            Coordinate lowerBoundCopy = this.zone.getLowerBound().clone();
            Coordinate upperBoundCopy = this.zone.getUpperBound().clone();
            lowerBoundCopy.setElement((int)dimension, (Element)estimatedMiddle);
            upperBoundCopy.setElement((int)dimension, (Element)estimatedMiddle);
            return HomogenousPair.createHomogenous((Object)((Object)new SemanticZone((Coordinate<SemanticElement>)this.zone.getLowerBound(), (Coordinate<SemanticElement>)upperBoundCopy)), (Object)((Object)new SemanticZone((Coordinate<SemanticElement>)lowerBoundCopy, (Coordinate<SemanticElement>)this.zone.getUpperBound())));
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    private static final class SubscriptionNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

