/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.operations.can;

import com.google.common.hash.HashCode;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.api.SubscriptionId;
import fr.inria.eventcloud.datastore.AccessMode;
import fr.inria.eventcloud.datastore.QuadrupleIterator;
import fr.inria.eventcloud.datastore.TransactionalDatasetGraph;
import fr.inria.eventcloud.datastore.TransactionalTdbDatastore;
import fr.inria.eventcloud.overlay.SemanticCanOverlay;
import fr.inria.eventcloud.pubsub.PublishSubscribeUtils;
import fr.inria.eventcloud.pubsub.Subscription;
import fr.inria.eventcloud.pubsub.notifications.BindingNotification;
import fr.inria.eventcloud.pubsub.notifications.NotificationId;
import java.util.concurrent.ExecutionException;
import org.objectweb.proactive.api.PAActiveObject;
import org.objectweb.proactive.extensions.p2p.structured.operations.RunnableOperation;
import org.objectweb.proactive.extensions.p2p.structured.overlay.StructuredOverlay;
import org.objectweb.proactive.extensions.p2p.structured.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetrieveSubSolutionOperation
implements RunnableOperation {
    private static final long serialVersionUID = 130L;
    private static final Logger log = LoggerFactory.getLogger(RetrieveSubSolutionOperation.class);
    private final NotificationId notificationId;
    private final HashCode hash;

    public RetrieveSubSolutionOperation(NotificationId id, HashCode hash) {
        this.notificationId = id;
        this.hash = hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(StructuredOverlay overlay) {
        SemanticCanOverlay semanticOverlay = (SemanticCanOverlay)overlay;
        TransactionalTdbDatastore datastore = semanticOverlay.getSubscriptionsDatastore();
        TransactionalDatasetGraph txnGraph = datastore.begin(AccessMode.READ_ONLY);
        Quadruple metaQuad = null;
        try {
            QuadrupleIterator result = txnGraph.find(PublishSubscribeUtils.createQuadrupleHashUri(this.hash), Node.ANY, Node.ANY, Node.ANY);
            if (!result.hasNext()) {
                log.error("Peer {} is expected to have a matching quadruple meta information for hash {}", (Object)overlay, (Object)this.hash);
            }
            metaQuad = result.next();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            txnGraph.end();
        }
        if (metaQuad != null) {
            Pair<Quadruple, SubscriptionId> extractedMetaInfo = PublishSubscribeUtils.extractMetaInformation(metaQuad);
            Subscription subscription = ((SemanticCanOverlay)overlay).findSubscription(PublishSubscribeUtils.extractSubscriptionId(metaQuad.getSubject()));
            if (subscription == null) {
                return;
            }
            Binding binding = PublishSubscribeUtils.filter((Quadruple)extractedMetaInfo.getFirst(), subscription.getResultVars(), subscription.getSubSubscriptions()[0].getAtomicQuery());
            try {
                subscription.getSubscriberProxy().receive(new BindingNotification(this.notificationId, (SubscriptionId)extractedMetaInfo.getSecond(), PAActiveObject.getUrl((Object)overlay.getStub()), binding));
            }
            catch (ExecutionException e) {
                log.error("No SubscribeProxy found under the given URL: " + subscription.getSubscriberUrl(), (Throwable)e);
            }
            txnGraph = datastore.begin(AccessMode.WRITE);
            try {
                txnGraph.delete(metaQuad);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                txnGraph.end();
            }
        }
    }
}

