/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.operations.can;

import com.google.common.collect.Lists;
import fr.inria.eventcloud.api.QuadruplePattern;
import fr.inria.eventcloud.datastore.AccessMode;
import fr.inria.eventcloud.datastore.TransactionalDatasetGraph;
import fr.inria.eventcloud.datastore.TransactionalTdbDatastore;
import fr.inria.eventcloud.operations.can.FindQuadruplesResponseOperation;
import fr.inria.eventcloud.overlay.SemanticCanOverlay;
import java.util.ArrayList;
import java.util.Iterator;
import org.objectweb.proactive.extensions.p2p.structured.operations.CallableOperation;
import org.objectweb.proactive.extensions.p2p.structured.operations.ResponseOperation;
import org.objectweb.proactive.extensions.p2p.structured.overlay.StructuredOverlay;

public final class FindQuadruplesOperation
extends CallableOperation {
    private static final long serialVersionUID = 130L;
    private final QuadruplePattern quadruplePattern;
    private final boolean useSubscriptionsDatastore;

    public FindQuadruplesOperation(QuadruplePattern quadruplePattern) {
        this(quadruplePattern, false);
    }

    public FindQuadruplesOperation(QuadruplePattern quadruplePattern, boolean useSubscriptionsDatastore) {
        this.quadruplePattern = quadruplePattern;
        this.useSubscriptionsDatastore = useSubscriptionsDatastore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseOperation handle(StructuredOverlay overlay) {
        ArrayList result = null;
        TransactionalTdbDatastore datastore = this.useSubscriptionsDatastore ? ((SemanticCanOverlay)overlay).getSubscriptionsDatastore() : ((SemanticCanOverlay)overlay).getMiscDatastore();
        TransactionalDatasetGraph txnGraph = datastore.begin(AccessMode.READ_ONLY);
        try {
            result = Lists.newArrayList((Iterator)txnGraph.find(this.quadruplePattern));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            txnGraph.end();
        }
        return new FindQuadruplesResponseOperation(result);
    }
}

