/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.messages.request.can;

import com.google.common.collect.ImmutableList;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.api.QuadruplePattern;
import fr.inria.eventcloud.datastore.AccessMode;
import fr.inria.eventcloud.datastore.TransactionalDatasetGraph;
import fr.inria.eventcloud.messages.request.can.StatefulQuadruplePatternRequest;
import fr.inria.eventcloud.messages.response.can.QuadruplePatternResponseProvider;
import fr.inria.eventcloud.overlay.SemanticCanOverlay;
import fr.inria.eventcloud.overlay.can.SemanticElement;
import fr.inria.eventcloud.reasoner.AtomicQuery;
import java.util.List;
import org.objectweb.proactive.extensions.p2p.structured.messages.request.can.AnycastRequest;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.CanOverlay;

public class SparqlAtomicRequest
extends StatefulQuadruplePatternRequest<List<Quadruple>> {
    private static final long serialVersionUID = 130L;
    private final AtomicQuery atomicQuery;

    public SparqlAtomicRequest(AtomicQuery atomicQuery) {
        super(atomicQuery.getQuadruplePattern(), new QuadruplePatternResponseProvider());
        this.atomicQuery = atomicQuery;
    }

    @Override
    public List<Quadruple> onPeerValidatingKeyConstraints(CanOverlay<SemanticElement> overlay, AnycastRequest<SemanticElement> request, QuadruplePattern quadruplePattern) {
        TransactionalDatasetGraph txnGraph = ((SemanticCanOverlay)overlay).getMiscDatastore().begin(AccessMode.READ_ONLY);
        try {
            QueryIterator iterator = Algebra.exec((Op)this.atomicQuery.getOpRepresentation(), (Dataset)txnGraph.getUnderlyingDataset());
            List<Quadruple> list = SparqlAtomicRequest.toQuadruples(iterator, this.atomicQuery);
            return list;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            txnGraph.end();
        }
    }

    private static List<Quadruple> toQuadruples(QueryIterator it, AtomicQuery atomicQuery) {
        ImmutableList.Builder builder = ImmutableList.builder();
        while (it.hasNext()) {
            Binding binding = (Binding)it.next();
            Node graph = SparqlAtomicRequest.getBoundValue(binding, atomicQuery.getGraph());
            Node subject = SparqlAtomicRequest.getBoundValue(binding, atomicQuery.getSubject());
            Node predicate = SparqlAtomicRequest.getBoundValue(binding, atomicQuery.getPredicate());
            Node object = SparqlAtomicRequest.getBoundValue(binding, atomicQuery.getObject());
            builder.add((Object)new Quadruple(graph, subject, predicate, object));
        }
        return builder.build();
    }

    private static Node getBoundValue(Binding binding, Node node) {
        if (node.isVariable()) {
            return binding.get(Var.alloc((String)node.getName()));
        }
        return node;
    }

    public String getQuery() {
        return this.atomicQuery.toString();
    }
}

