/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.messages.request.can;

import com.google.common.hash.HashCode;
import com.hp.hpl.jena.graph.Node;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.api.QuadruplePattern;
import fr.inria.eventcloud.datastore.AccessMode;
import fr.inria.eventcloud.datastore.QuadrupleIterator;
import fr.inria.eventcloud.datastore.TransactionalDatasetGraph;
import fr.inria.eventcloud.messages.request.can.QuadruplePatternRequest;
import fr.inria.eventcloud.overlay.SemanticCanOverlay;
import fr.inria.eventcloud.overlay.can.SemanticElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.objectweb.proactive.extensions.p2p.structured.messages.request.can.AnycastRequest;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.CanOverlay;
import org.objectweb.proactive.extensions.p2p.structured.utils.SerializedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconstructCompoundEventRequest
extends QuadruplePatternRequest {
    private static final long serialVersionUID = 130L;
    private static final Logger log = LoggerFactory.getLogger(ReconstructCompoundEventRequest.class);
    private SerializedValue<Set<HashCode>> hashValuesReceived;
    private SerializedValue<String> metaGraphValue;

    public ReconstructCompoundEventRequest(QuadruplePattern quadruplePattern, Set<HashCode> hashValuesReceived) {
        super(quadruplePattern);
        this.hashValuesReceived = SerializedValue.create(hashValuesReceived);
        this.metaGraphValue = SerializedValue.create((Object)quadruplePattern.createMetaGraphNode().getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Quadruple> onPeerValidatingKeyConstraints(CanOverlay<SemanticElement> overlay, AnycastRequest<SemanticElement> request, QuadruplePattern quadruplePattern) {
        Set hashValues = (Set)this.hashValuesReceived.getValue();
        ArrayList<Quadruple> result = new ArrayList<Quadruple>();
        TransactionalDatasetGraph txnGraph = ((SemanticCanOverlay)overlay).getMiscDatastore().begin(AccessMode.READ_ONLY);
        try {
            QuadrupleIterator iterator = txnGraph.find(Node.createURI((String)((String)this.metaGraphValue.getValue())), Node.ANY, Node.ANY, Node.ANY);
            while (iterator.hasNext()) {
                Quadruple quadruple = iterator.next();
                if (quadruple.getPublicationTime() == -1L || hashValues.contains(quadruple.hashValue())) continue;
                result.add(quadruple);
            }
            log.info("Retrieved {} new event(s) on {} for meta graph node {}", new Object[]{result.size(), overlay, this.metaGraphValue.getValue()});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            txnGraph.end();
        }
        return result;
    }
}

