/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.messages.request.can;

import com.google.common.collect.ImmutableList;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.optimize.Optimize;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.E_Datatype;
import com.hp.hpl.jena.sparql.expr.E_Equals;
import com.hp.hpl.jena.sparql.expr.E_LogicalAnd;
import com.hp.hpl.jena.sparql.expr.E_LogicalOr;
import com.hp.hpl.jena.sparql.expr.E_SameTerm;
import com.hp.hpl.jena.sparql.expr.E_Str;
import com.hp.hpl.jena.sparql.expr.E_StrStartsWith;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import fr.inria.eventcloud.api.PublishSubscribeConstants;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.api.QuadruplePattern;
import fr.inria.eventcloud.api.SubscriptionId;
import fr.inria.eventcloud.configuration.EventCloudProperties;
import fr.inria.eventcloud.datastore.AccessMode;
import fr.inria.eventcloud.datastore.QuadrupleIterator;
import fr.inria.eventcloud.datastore.TransactionalDatasetGraph;
import fr.inria.eventcloud.datastore.Vars;
import fr.inria.eventcloud.messages.request.can.QuadrupleRequest;
import fr.inria.eventcloud.overlay.SemanticCanOverlay;
import fr.inria.eventcloud.proxies.SubscribeProxy;
import fr.inria.eventcloud.pubsub.PublishSubscribeUtils;
import fr.inria.eventcloud.pubsub.Subscription;
import fr.inria.eventcloud.pubsub.notifications.QuadruplesNotification;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.objectweb.proactive.api.PAActiveObject;
import org.objectweb.proactive.extensions.p2p.structured.configuration.P2PStructuredProperties;
import org.objectweb.proactive.extensions.p2p.structured.overlay.StructuredOverlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishQuadrupleRequest
extends QuadrupleRequest {
    private static final long serialVersionUID = 130L;
    private static final Logger log = LoggerFactory.getLogger(PublishQuadrupleRequest.class);

    public PublishQuadrupleRequest(Quadruple quad) {
        super(quad, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDestinationReached(StructuredOverlay overlay, Quadruple quadruple) {
        SemanticCanOverlay semanticOverlay = (SemanticCanOverlay)overlay;
        Node metaGraphNode = quadruple.createMetaGraphNode();
        if (((Boolean)P2PStructuredProperties.ENABLE_BENCHMARKS_INFORMATION.getValue()).booleanValue()) {
            log.info("Peer " + overlay + " is about to store quadruple " + quadruple.getSubject() + " " + quadruple.getPredicate() + " " + quadruple.getObject());
        }
        TransactionalDatasetGraph txnGraph = semanticOverlay.getMiscDatastore().begin(AccessMode.WRITE);
        try {
            txnGraph.add(metaGraphNode, quadruple.getSubject(), quadruple.getPredicate(), quadruple.getObject());
            txnGraph.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            txnGraph.end();
        }
        txnGraph = semanticOverlay.getSubscriptionsDatastore().begin(AccessMode.READ_ONLY);
        HashSet<Subscription> subscriptionsMatching = new HashSet<Subscription>();
        QueryIterator it = null;
        try {
            Optimize.noOptimizer();
            it = Algebra.exec((Op)PublishQuadrupleRequest.createAlgebraRetrievingSubscriptionsMatching(quadruple), (Dataset)txnGraph.getUnderlyingDataset());
            while (it.hasNext()) {
                Binding binding = it.nextBinding();
                log.debug("Peer {} has a sub subscription that matches the quadruple {} ", (Object)overlay, (Object)quadruple);
                SubscriptionId subscriptionId = SubscriptionId.parseSubscriptionId((String)binding.get(Vars.SUBSCRIPTION_ID).getLiteralLexicalForm());
                Subscription subscription = semanticOverlay.findSubscription(txnGraph, subscriptionId);
                subscriptionsMatching.add(subscription);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (it != null) {
                it.close();
            }
            txnGraph.end();
            Optimize.setFactory((Optimize.RewriterFactory)Optimize.stdOptimizationFactory);
        }
        for (Subscription subscriptionMatching : subscriptionsMatching) {
            PublishSubscribeUtils.rewriteSubscriptionOrNotifySender(semanticOverlay, subscriptionMatching, quadruple);
        }
        if (EventCloudProperties.isSbce2PubSubAlgorithmUsed()) {
            txnGraph = semanticOverlay.getSubscriptionsDatastore().begin(AccessMode.READ_ONLY);
            try {
                QuadrupleIterator qit = txnGraph.find(new QuadruplePattern(metaGraphNode, null, PublishSubscribeConstants.SUBSCRIPTION_SUBSCRIBER_NODE, null));
                while (qit.hasNext()) {
                    Quadruple q = qit.next();
                    SubscriptionId subscriptionId = PublishSubscribeUtils.extractSubscriptionId(q.getSubject());
                    String subscriberUrl = q.getObject().getURI();
                    QuadruplesNotification n = new QuadruplesNotification(subscriptionId, metaGraphNode, PAActiveObject.getUrl((Object)semanticOverlay.getStub()), (List<Quadruple>)ImmutableList.of((Object)quadruple));
                    if (!semanticOverlay.markAsSent(n.getId(), quadruple)) continue;
                    ((SubscribeProxy)Subscription.SUBSCRIBE_PROXIES_CACHE.get((Object)subscriberUrl)).receive(n);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                txnGraph.end();
            }
        }
    }

    private static Op createAlgebraRetrievingSubscriptionsMatching(Quadruple quad) {
        BasicPattern bp = new BasicPattern();
        bp.add(Triple.create((Node)Vars.SUBSUBSCRIPTION_SOURCE, (Node)PublishSubscribeConstants.SUBSUBSCRIPTION_GRAPH_VALUE_NODE, (Node)Vars.SUBSUBSCRIPTION_GRAPH));
        bp.add(Triple.create((Node)Vars.SUBSUBSCRIPTION_SOURCE, (Node)PublishSubscribeConstants.SUBSUBSCRIPTION_SUBJECT_VALUE_NODE, (Node)Vars.SUBSUBSCRIPTION_SUBJECT));
        bp.add(Triple.create((Node)Vars.SUBSUBSCRIPTION_SOURCE, (Node)PublishSubscribeConstants.SUBSUBSCRIPTION_PREDICATE_VALUE_NODE, (Node)Vars.SUBSUBSCRIPTION_PREDICATE));
        bp.add(Triple.create((Node)Vars.SUBSUBSCRIPTION_SOURCE, (Node)PublishSubscribeConstants.SUBSUBSCRIPTION_OBJECT_VALUE_NODE, (Node)Vars.SUBSUBSCRIPTION_OBJECT));
        bp.add(Triple.create((Node)Vars.SUBSUBSCRIPTION_SOURCE, (Node)PublishSubscribeConstants.SUBSUBSCRIPTION_ID_NODE, (Node)Vars.SUBSUBSCRIPTION_ID));
        bp.add(Triple.create((Node)Vars.SUBSCRIPTION_SOURCE, (Node)PublishSubscribeConstants.SUBSCRIPTION_INDEXED_WITH_NODE, (Node)Vars.SUBSUBSCRIPTION_ID));
        bp.add(Triple.create((Node)Vars.SUBSCRIPTION_SOURCE, (Node)PublishSubscribeConstants.SUBSCRIPTION_ID_NODE, (Node)Vars.SUBSCRIPTION_ID));
        NodeValue ssVariableExpr = NodeValue.makeNode((Node)PublishSubscribeConstants.SUBSCRIPTION_VARIABLE_NODE);
        ExprVar ssGraphExprVar = new ExprVar(Vars.SUBSUBSCRIPTION_GRAPH);
        NodeValue graphExpr = NodeValue.makeNode((Node)quad.getGraph());
        E_LogicalOr graphConditions = new E_LogicalOr((Expr)new E_StrStartsWith((Expr)new E_Str((Expr)ssGraphExprVar), (Expr)graphExpr), (Expr)new E_LogicalOr((Expr)new E_Equals((Expr)new E_Datatype((Expr)ssGraphExprVar), (Expr)ssVariableExpr), (Expr)new E_Equals((Expr)ssGraphExprVar, (Expr)graphExpr)));
        ExprVar ssSubjectExprVar = new ExprVar(Vars.SUBSUBSCRIPTION_SUBJECT);
        E_LogicalOr subjectConditions = new E_LogicalOr((Expr)new E_SameTerm((Expr)ssSubjectExprVar, (Expr)NodeValue.makeNode((Node)quad.getSubject())), (Expr)new E_Equals((Expr)new E_Datatype((Expr)ssSubjectExprVar), (Expr)ssVariableExpr));
        ExprVar ssPredicateExprVar = new ExprVar(Vars.SUBSUBSCRIPTION_PREDICATE);
        E_LogicalOr predicateConditions = new E_LogicalOr((Expr)new E_SameTerm((Expr)ssPredicateExprVar, (Expr)NodeValue.makeNode((Node)quad.getPredicate())), (Expr)new E_Equals((Expr)new E_Datatype((Expr)ssPredicateExprVar), (Expr)ssVariableExpr));
        ExprVar ssObjectExprVar = new ExprVar(Vars.SUBSUBSCRIPTION_OBJECT);
        E_LogicalOr objectConditions = new E_LogicalOr((Expr)new E_SameTerm((Expr)ssObjectExprVar, (Expr)NodeValue.makeNode((Node)quad.getObject())), (Expr)new E_Equals((Expr)new E_Datatype((Expr)ssObjectExprVar), (Expr)ssVariableExpr));
        Op filter = OpFilter.filter((Expr)new E_LogicalAnd((Expr)graphConditions, (Expr)new E_LogicalAnd((Expr)subjectConditions, (Expr)new E_LogicalAnd((Expr)predicateConditions, (Expr)objectConditions))), (Op)new OpBGP(bp));
        return new OpProject((Op)new OpGraph((Node)Vars.GRAPH, filter), Arrays.asList(Vars.SUBSCRIPTION_ID));
    }
}

