/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.messages.request.can;

import com.hp.hpl.jena.graph.Node;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.api.QuadruplePattern;
import fr.inria.eventcloud.datastore.AccessMode;
import fr.inria.eventcloud.datastore.QuadrupleIterator;
import fr.inria.eventcloud.datastore.TransactionalDatasetGraph;
import fr.inria.eventcloud.messages.request.can.StatelessQuadruplePatternRequest;
import fr.inria.eventcloud.overlay.SemanticCanOverlay;
import fr.inria.eventcloud.overlay.can.SemanticElement;
import fr.inria.eventcloud.pubsub.PublishSubscribeUtils;
import fr.inria.eventcloud.pubsub.Subscription;
import fr.inria.eventcloud.pubsub.Subsubscription;
import java.util.ArrayList;
import org.objectweb.proactive.extensions.p2p.structured.configuration.P2PStructuredProperties;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.CanOverlay;
import org.objectweb.proactive.extensions.p2p.structured.utils.SerializedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSubscriptionRequest
extends StatelessQuadruplePatternRequest {
    private static final long serialVersionUID = 130L;
    private static final Logger log = LoggerFactory.getLogger(IndexSubscriptionRequest.class);
    protected SerializedValue<Subscription> subscription;

    public IndexSubscriptionRequest(Subscription subscription) {
        super(subscription.getSubSubscriptions()[0].getAtomicQuery().getQuadruplePattern(), null);
        this.subscription = SerializedValue.create((Object)subscription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPeerValidatingKeyConstraints(CanOverlay<SemanticElement> overlay, QuadruplePattern quadruplePattern) {
        SemanticCanOverlay semanticOverlay = (SemanticCanOverlay)overlay;
        Subscription subscription = (Subscription)this.subscription.getValue();
        if (((Boolean)P2PStructuredProperties.ENABLE_BENCHMARKS_INFORMATION.getValue()).booleanValue()) {
            log.info("It took " + (System.currentTimeMillis() - subscription.getCreationTime()) + "ms to receive subscription : " + subscription.getSparqlQuery());
        }
        log.debug("Indexing subscription {} on peer {}", (Object)subscription, overlay);
        semanticOverlay.storeSubscription(subscription);
        Subsubscription firstSubsubscription = subscription.getSubSubscriptions()[0];
        ArrayList<Quadruple> quadruplesMatching = new ArrayList<Quadruple>();
        QuadruplePattern qp = firstSubsubscription.getAtomicQuery().getQuadruplePattern();
        TransactionalDatasetGraph txnGraph = ((SemanticCanOverlay)overlay).getMiscDatastore().begin(AccessMode.READ_ONLY);
        try {
            QuadrupleIterator it = txnGraph.find(Node.ANY, qp.getSubject(), qp.getPredicate(), qp.getObject());
            while (it.hasNext()) {
                Quadruple q = it.next();
                if (qp.getGraph() != Node.ANY && !q.getGraph().getURI().startsWith(qp.getGraph().getURI())) continue;
                quadruplesMatching.add(q);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            txnGraph.end();
        }
        for (Quadruple quadrupleMatching : quadruplesMatching) {
            if (log.isDebugEnabled() && quadrupleMatching.getPublicationTime() != -1L) {
                log.debug("Comparing the timestamps between the quadruple and the subscription matching the quadruple:\n{}\n{}", (Object)quadrupleMatching, (Object)subscription);
            }
            if (quadrupleMatching.getPublicationTime() < subscription.getIndexationTime()) continue;
            PublishSubscribeUtils.rewriteSubscriptionOrNotifySender(semanticOverlay, subscription, quadrupleMatching);
        }
    }
}

