/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.messages.request.can;

import com.google.common.collect.ImmutableList;
import com.hp.hpl.jena.graph.Node;
import fr.inria.eventcloud.api.PublishSubscribeConstants;
import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.api.QuadruplePattern;
import fr.inria.eventcloud.api.SubscriptionId;
import fr.inria.eventcloud.datastore.AccessMode;
import fr.inria.eventcloud.datastore.QuadrupleIterator;
import fr.inria.eventcloud.datastore.TransactionalDatasetGraph;
import fr.inria.eventcloud.messages.request.can.StatelessQuadruplePatternRequest;
import fr.inria.eventcloud.overlay.SemanticCanOverlay;
import fr.inria.eventcloud.overlay.can.SemanticElement;
import fr.inria.eventcloud.proxies.SubscribeProxy;
import fr.inria.eventcloud.pubsub.PublishSubscribeUtils;
import fr.inria.eventcloud.pubsub.Subscription;
import fr.inria.eventcloud.pubsub.notifications.NotificationId;
import fr.inria.eventcloud.pubsub.notifications.QuadruplesNotification;
import java.util.List;
import org.objectweb.proactive.api.PAActiveObject;
import org.objectweb.proactive.extensions.p2p.structured.overlay.can.CanOverlay;
import org.objectweb.proactive.extensions.p2p.structured.utils.SerializedValue;

public class IndexEphemeralSubscriptionRequest
extends StatelessQuadruplePatternRequest {
    private static final long serialVersionUID = 130L;
    private final SerializedValue<SubscriptionId> subscriptionId;
    private final SerializedValue<String> subscriberUrl;
    private final SerializedValue<String> metaGraph;

    public IndexEphemeralSubscriptionRequest(Node graph, SubscriptionId subscriptionId, String subscriberUrl) {
        super(new QuadruplePattern(Quadruple.removeMetaInformation((Node)graph), Node.ANY, Node.ANY, Node.ANY, true), null);
        this.metaGraph = SerializedValue.create((Object)graph.getURI());
        this.subscriptionId = SerializedValue.create((Object)subscriptionId);
        this.subscriberUrl = SerializedValue.create((Object)subscriberUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPeerValidatingKeyConstraints(CanOverlay<SemanticElement> overlay, QuadruplePattern quadruplePattern) {
        SemanticCanOverlay semanticOverlay = (SemanticCanOverlay)overlay;
        if (!this.storeEphemeralSubscription(semanticOverlay)) {
            return;
        }
        Node metaGraphNode = Node.createURI((String)((String)this.metaGraph.getValue()));
        TransactionalDatasetGraph txnGraph = semanticOverlay.getMiscDatastore().begin(AccessMode.READ_ONLY);
        try {
            QuadrupleIterator it = txnGraph.find(metaGraphNode, Node.ANY, Node.ANY, Node.ANY);
            if (it.hasNext()) {
                NotificationId notificationId = new NotificationId((SubscriptionId)this.subscriptionId.getValue(), metaGraphNode);
                ImmutableList.Builder builder = ImmutableList.builder();
                while (it.hasNext()) {
                    Quadruple quadruple = it.next();
                    if (!semanticOverlay.markAsSent(notificationId, quadruple)) continue;
                    builder.add((Object)quadruple);
                }
                ImmutableList quadruples = builder.build();
                if (!quadruples.isEmpty()) {
                    QuadruplesNotification n = new QuadruplesNotification((SubscriptionId)this.subscriptionId.getValue(), metaGraphNode, PAActiveObject.getUrl((Object)semanticOverlay.getStub()), (List<Quadruple>)quadruples);
                    ((SubscribeProxy)Subscription.SUBSCRIBE_PROXIES_CACHE.get(this.subscriberUrl.getValue())).receive(n);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            txnGraph.end();
        }
    }

    private final boolean storeEphemeralSubscription(SemanticCanOverlay overlay) {
        TransactionalDatasetGraph txnGraph = overlay.getSubscriptionsDatastore().begin(AccessMode.WRITE);
        try {
            txnGraph.add(this.createEphemeralSubscriptionQuadruple());
            txnGraph.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            txnGraph.end();
        }
    }

    private final Quadruple createEphemeralSubscriptionQuadruple() {
        return new Quadruple(Node.createURI((String)((String)this.metaGraph.getValue())), PublishSubscribeUtils.createSubscriptionIdUri((SubscriptionId)this.subscriptionId.getValue()), PublishSubscribeConstants.SUBSCRIPTION_SUBSCRIBER_NODE, Node.createURI((String)((String)this.subscriberUrl.getValue())));
    }
}

