/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.messages.request.can;

import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.datastore.AccessMode;
import fr.inria.eventcloud.datastore.TransactionalDatasetGraph;
import fr.inria.eventcloud.messages.request.can.QuadrupleRequest;
import fr.inria.eventcloud.overlay.SemanticCanOverlay;
import org.objectweb.proactive.extensions.p2p.structured.overlay.StructuredOverlay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteQuadrupleRequest
extends QuadrupleRequest {
    private static final long serialVersionUID = 130L;
    private static final Logger logger = LoggerFactory.getLogger(DeleteQuadrupleRequest.class);

    public DeleteQuadrupleRequest(Quadruple quad) {
        super(quad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDestinationReached(StructuredOverlay overlay, Quadruple quad) {
        TransactionalDatasetGraph txnGraph = ((SemanticCanOverlay)overlay).getMiscDatastore().begin(AccessMode.WRITE);
        try {
            txnGraph.delete(quad);
            txnGraph.commit();
            logger.info("Quadruple {} removed from {}", (Object)quad, (Object)overlay);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            txnGraph.end();
        }
    }
}

