/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.eventcloud.messages.request.can;

import fr.inria.eventcloud.api.Quadruple;
import fr.inria.eventcloud.datastore.AccessMode;
import fr.inria.eventcloud.datastore.TransactionalDatasetGraph;
import fr.inria.eventcloud.messages.request.can.QuadrupleRequest;
import fr.inria.eventcloud.overlay.SemanticCanOverlay;
import org.objectweb.proactive.extensions.p2p.structured.overlay.StructuredOverlay;
import org.objectweb.proactive.extensions.p2p.structured.utils.StringRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddQuadrupleRequest
extends QuadrupleRequest {
    private static final long serialVersionUID = 130L;
    private static final Logger logger = LoggerFactory.getLogger(AddQuadrupleRequest.class);

    public AddQuadrupleRequest(Quadruple quad) {
        super(quad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDestinationReached(StructuredOverlay overlay, Quadruple quad) {
        TransactionalDatasetGraph txnGraph = ((SemanticCanOverlay)overlay).getMiscDatastore().begin(AccessMode.WRITE);
        try {
            txnGraph.add(quad);
            txnGraph.commit();
            logger.info("Quadruple {} added on {}", (Object)quad.toString(StringRepresentation.CODE_POINTS), (Object)overlay);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            txnGraph.end();
        }
    }
}

